
local ae = require "apolloengine"
local mf = require "mathfunction"

local threshold = {}

function threshold:Initialize(host, size)
  self.renderObject = nil
  self.Queue = 100
        
  self.Threshold = mf.vector1(128.0);

  self.POST_EFFECT_ALPHA = ae.IMaterialSystem:NewParameterSlot(
    ae.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");
  
  self.material = host:CreateMaterial("comm:documents/shaders/posteffect/threshold.material");
  self.renderObject = host:CreateRenderObject();

  self.material:SetParameter(self.POST_EFFECT_ALPHA, mf.vector1(1.0));
  
  host:RegisterScriptParameter(self, "Threshold");
  
  return self.Queue
end

function threshold:Resizeview(size)
end

function threshold:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, ae.RenderTargetEntity.CF_COLOR);

  local material = self.material;
    
  material:SetParameter(
          "_MainTex",
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));
  
  material:SetParameter("_Threshold", mf.vector1(math.max(math.min(self.Threshold:x() / 255.0,1.0),0.0)) );
  
  context:Draw(self.renderObject, self.material);
  context:EndRenderPass();
end


return threshold;