local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local skinbright = {}
skinbright.Do = 0;
skinbright.Queue = 150;

function skinbright:Initialize(host, size)
  self.intensity = 1.0;
  self.lutPath = "docs:beauty/lut.png";
  self.lastLutPath = "docs:beauty/lut.png";
  self.tex = apolloengine.TextureEntity();
  self.tex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.lutPath));
  self.tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.tex:CreateResource();
  
  self.LOOKUPTABLE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "LOOKUPTABLE");
  self.TEXTURE_BRIGHTLUT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BRIGHTLUT");
  self.UNIFORM_INTENSITY = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_INTENSITY");
  
  --start
  --self.BrightLut = host:CreateRenderObject( "comm:documents/material/lut.material" );
  self.BrightLutMat = host:CreateMaterial( "comm:documents/material/lut.material" );
  self.BrightLutRO = host:CreateRenderObject();
  --self.BrightLut:SetParameter(self.LOOKUPTABLE,self.tex);
  self.BrightLutMat:SetParameter(self.LOOKUPTABLE,self.tex);
  --end
  
  --start
  --self.Blend = host:CreateRenderObject( "comm:documents/material/skinbrightblend.material" );
  self.BlendMat = host:CreateMaterial( "comm:documents/material/skinbrightblend.material" );
  self.BlendRO = host:CreateRenderObject();
  --self.Blend:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
  self.BlendMat:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
  --end
  self.LutRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  
  return self.Queue;
end



function skinbright:Resizeview(size)
end

function skinbright:Process(context, Original, Scene, Output)
  if(self.lutPath ~= self.lastLutPath)
  then
    self.newtex = apolloengine.TextureEntity();
    self.newtex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.lutPath));
    self.newtex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    self.newtex:CreateResource();
    self.BrightLut:SetParameter(self.LOOKUPTABLE,self.newtex);
    self.lastLutPath = self.lutPath;
  end
  
  --start
  --self.LutRT:PushRenderTarget();
  --self.LutRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(self.LutRT, apolloengine.RenderTargetEntity.CF_COLOR);
  
  --	self.BrightLut:SetParameter(
  --		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.BrightLutMat:SetParameter(
  apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  --self.BrightLut:Draw(pipeline);
  context:Draw(self.BrightLutRO, self.BrightLutMat);
  context:EndRenderPass();
 --end
  
  --start
  --Output:PushRenderTarget();
  --Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  --self.Blend:SetParameter(self.TEXTURE_BRIGHTLUT,self.LutRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  self.BlendMat:SetParameter(self.TEXTURE_BRIGHTLUT,self.LutRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  --self.Blend:SetParameter(
  --	apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  --	Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.BlendMat:SetParameter(
  	apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  	Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  --self.Blend:Draw(pipeline);
  context:Draw(self.BlendRO, self.BlendMat);
  context:EndRenderPass();
  --end
end

return skinbright;