local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local Outline = {}
Outline.DoMaterial = 0;
Outline.DoRenderObj = 0;
Outline.Queue = 310;

function Outline:Initialize(host, size)
  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/outline.material");
  self.DoMaterial = host:CreateMaterial(pathout);
  self.DoRenderObj = host:CreateRenderObject();

  self.DoMaterial:SetParameter(self.TARGETSIZE,size);

  return self.Queue;
end



function Outline:Resizeview(size)
  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
end

function Outline:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  context:Draw(self.DoRenderObj, self.DoMaterial);
  context:EndRenderPass();
end

return Outline;