local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local lut = {}

function lut:Initialize(host, size)
  self.DoMaterial  = 0;
  self.DoRenderObj = 0;
  self.Queue = 310;

  --self.lutPath = "docs:lutpics/lut.png";
  --self.lastLutPath = "docs:lutpics/lut.png";
  self.lutPath = "comm:documents/texture/posteffect/lut.png";
  self.lastLutPath = "comm:documents/texture/posteffect/lut.png";
  self.LutTexEntity = apolloengine.TextureEntity();
  self.LastLutTexEntity = self.LutTexEntity;
  
  self.tex = apolloengine.TextureEntity();
  self.tex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.lutPath));
  self.tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.tex:CreateResource();
  self.LOOKUPTABLE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "LOOKUPTABLE");

  self.POST_EFFECT_ALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "POST_EFFECT_ALPHA");
  
  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/lut.material");
  self.DoMaterial = host:CreateMaterial(pathout);
  self.DoRenderObj = host:CreateRenderObject();
  self.DoMaterial:SetParameter(self.LOOKUPTABLE,self.tex);
  self.DoMaterial:SetParameter(self.POST_EFFECT_ALPHA, mathfunction.vector1(1.0));
  
  --host:RegisterScriptParameter(self,"lutPath");
  host:RegisterScriptParameter(self,"LutTexEntity");
  return self.Queue;
end



function lut:Resizeview(size)
end

function lut:Process(context, Original, Scene, Output)
  if(self.lutPath ~= self.lastLutPath)
  then
    self.newtex = apolloengine.TextureEntity();
    self.newtex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.lutPath));
    self.newtex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    self.newtex:CreateResource();
    self.DoMaterial:SetParameter(self.LOOKUPTABLE,self.newtex);
    self.lastLutPath = self.lutPath;
  end
 
  if self.LutTexEntity ~= self.LastLutTexEntity then
    self.DoMaterial:SetParameter(self.LOOKUPTABLE,self.LutTexEntity);
  end
  
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.DoRenderObj, self.DoMaterial);
  context:EndRenderPass();
end

return lut;