local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

require "utility"

local bloomEffect = {}
bloomEffect.Rt = 0;
bloomEffect.Rt1 = 0;
bloomEffect.Rt2 = 0;
bloomEffect.Rt3 = 0;

--bloomEffect.bluraround = 0;
--bloomEffect.bluraroundT = 0;
--bloomEffect.blurHorizon = 0;
--bloomEffect.blurVertical = 0;

bloomEffect.bluraroundRenderObj = 0;
bloomEffect.bluraroundTRenderObj = 0;
bloomEffect.blurHorizonRenderObj = 0;
bloomEffect.blurVerticalRenderObj = 0;
bloomEffect.bloomcombineRenderObj = 0;
bloomEffect.finalbloomRenderObj = 0;

bloomEffect.bluraroundMaterial = 0;
bloomEffect.bluraroundTMaterial = 0;
bloomEffect.blurHorizonMaterial = 0;
bloomEffect.blurVerticalMaterial = 0;
bloomEffect.bloomcombineMaterial = 0;
bloomEffect.finalbloomMaterial = 0;

bloomEffect.blurradius = 0;
bloomEffect.bloomparam = 0;
bloomEffect.gamma = 0;
bloomEffect.bloomthreshold = 0;
bloomEffect.maxluminance = 0;
bloomEffect.Queue = 100;

function bloomEffect:Initialize(host, size)

  self.fbosize = mathfunction.vector2(size:x(), size:y());

  self.AROUND_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "AROUND_COORDNATE");
  self.TEXELSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXELSIZE");
  self.BLOOM_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLOOM_THRESHOLD");
  self.BLUR_RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLUR_RADIUS");

  self.TEXTURE_BLUR1 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR1");
  self.TEXTURE_BLUR2 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR2");
  self.TEXTURE_BLUR3 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR3");

  self.TEXTURE_BLOOM = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLOOM");
  self.TEXTURE_CURVE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_CURVE");
  self.BLOOM_PARAM = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLOOM_PARAM");
  self.GAMMA = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAMMA");
  self.MAXLUMINANCE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "MAXLUMINANCE");

  self.bluraroundMaterial = host:CreateMaterial( "comm:documents/superme_bloom/superme_blur.material" );
  self.bluraroundRenderObj = host:CreateRenderObject();

  self.bluraroundTMaterial = host:CreateMaterial( "comm:documents/superme_bloom/superme_blurT.material" );
  self.bluraroundTRenderObj = host:CreateRenderObject();

  self.blurHorizonMaterial = host:CreateMaterial( "comm:documents/superme_bloom/superme_blurH.material" );
  self.blurHorizonRenderObj = host:CreateRenderObject();

  self.blurVerticalMaterial = host:CreateMaterial( "comm:documents/superme_bloom/superme_blurV.material" );
  self.blurVerticalRenderObj = host:CreateRenderObject();

  self.bloomcombineMaterial = host:CreateMaterial( "comm:documents/superme_bloom/superme_bloomcombine.material" );
  self.bloomcombineRenderObj = host:CreateRenderObject();

  self.finalbloomMaterial = host:CreateMaterial( "comm:documents/superme_bloom/superme_bloom.material" );
  self.finalbloomRenderObj = host:CreateRenderObject();


  --self.blit = host:CreateRenderObject( "comm:documents/material/blit.material");


  self.maxluminance = mathfunction.vector2(0.998, 1.002);
  self.blurradius = mathfunction.vector2(0.83, 1.481);
  self.bloomparam = mathfunction.vector1(3.0);
  self.bloomthreshold = mathfunction.vector1(0.83);
  self.gamma = mathfunction.vector1(0.667);

  --[[self.curveTex = apolloengine.TextureEntity();
  self.curveTex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        "docs:superme3d/dollmaterial/Curvetex.png"));
  self.curveTex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.curveTex:CreateResource();]]--

	self.Rt = host:CreateRenderTarget(
    apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));

  local scale = 1.0 / 4.0
  self.Rt1 = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));

  self.Rt1_a = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
 -- self.Rt1_a:SetResizeviewFlag(false);

  scale = 1.0 / 8.0

  self.Rt2 = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
 -- self.Rt2:SetResizeviewFlag(false);
  self.Rt2_a = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  --self.Rt2_a:SetResizeviewFlag(false);

  scale = 1.0 / 16.0

  self.Rt3 = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  --self.Rt3:SetResizeviewFlag(false);
  self.Rt3_a = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  --self.Rt3_a:SetResizeviewFlag(false);
  host:RegisterScriptParameter(self,"blurradius");
  host:RegisterScriptParameter(self,"bloomparam");
  --host:RegisterScriptParameter(self,"gamma");
  host:RegisterScriptParameter(self,"bloomthreshold");
  --host:RegisterScriptParameter(self,"maxluminance");
  return self.Queue;
end

function bloomEffect:Resizeview(size)
  self.fbosize = mathfunction.vector2(size:x(), size:y());
end

function bloomEffect:Process(context, Original, Scene, Output)

  local layerDepth = 2.0;

  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.bluraroundTMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bluraroundTMaterial:SetParameter( self.BLOOM_THRESHOLD, self.bloomthreshold );
  self.bluraroundTMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2( 1.0 / self.fbosize:x(), 1.0 / self.fbosize:y() ) );
  context:Draw(self.bluraroundTRenderObj, self.bluraroundTMaterial);
  context:EndRenderPass();


  context:BeginRenderPass(self.Rt1_a, apolloengine.RenderTargetEntity.CF_COLOR);
  self.blurHorizonMaterial:SetParameter( self.BLUR_RADIUS, self.blurradius );
  self.blurHorizonMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurHorizonMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(4.0 / self.fbosize:x(), 4.0 / self.fbosize:y() ) );
  context:Draw(self.blurHorizonRenderObj, self.blurHorizonMaterial);
  context:EndRenderPass();


  context:BeginRenderPass(self.Rt1, apolloengine.RenderTargetEntity.CF_COLOR);
  self.blurVerticalMaterial:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurVerticalMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1_a:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurVerticalMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(4.0 / self.fbosize:x(), 4.0 / self.fbosize:y() ) );  
  context:Draw(self.blurVerticalRenderObj, self.blurVerticalMaterial);
  context:EndRenderPass();
  
  layerDepth = 4.0;

  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.bluraroundMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
  self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bluraroundMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(4.0 / self.fbosize:x(), 4.0 / self.fbosize:y() ) );
  context:Draw(self.bluraroundRenderObj, self.bluraroundMaterial);
  context:EndRenderPass();


  context:BeginRenderPass(self.Rt2_a, apolloengine.RenderTargetEntity.CF_COLOR);
  self.blurHorizonMaterial:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurHorizonMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurHorizonMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(8.0 / self.fbosize:x(), 8.0 / self.fbosize:y() ) );
  context:Draw(self.blurHorizonRenderObj, self.blurHorizonMaterial);
  context:EndRenderPass();


  context:BeginRenderPass(self.Rt2, apolloengine.RenderTargetEntity.CF_COLOR);
  self.blurVerticalMaterial:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurVerticalMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2_a:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurVerticalMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(8.0 / self.fbosize:x(), 8.0 / self.fbosize:y() ) );
  context:Draw(self.blurVerticalRenderObj, self.blurVerticalMaterial);
  context:EndRenderPass();

  layerDepth = 8.0;

  context:BeginRenderPass(self.Rt3, apolloengine.RenderTargetEntity.CF_COLOR);
  self.bluraroundMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bluraroundMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(8.0 / self.fbosize:x(), 8.0 / self.fbosize:y() ) );
  context:Draw(self.bluraroundRenderObj, self.bluraroundMaterial);
  context:EndRenderPass();


  context:BeginRenderPass(self.Rt3_a, apolloengine.RenderTargetEntity.CF_COLOR);
  self.blurHorizonMaterial:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurHorizonMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt3:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurHorizonMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(16.0 / self.fbosize:x(), 16.0 / self.fbosize:y() ) );
  context:Draw(self.blurHorizonRenderObj, self.blurHorizonMaterial);
  context:EndRenderPass();


  context:BeginRenderPass(self.Rt3, apolloengine.RenderTargetEntity.CF_COLOR);
  self.blurVerticalMaterial:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurVerticalMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt3_a:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurVerticalMaterial:SetParameter( self.TEXELSIZE, mathfunction.vector2(16.0 / self.fbosize:x(), 16.0 / self.fbosize:y() ) );
   context:Draw(self.blurVerticalRenderObj, self.blurVerticalMaterial);
   context:EndRenderPass();


  context:BeginRenderPass(self.Rt, apolloengine.RenderTargetEntity.CF_COLOR);
  self.bloomcombineMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bloomcombineMaterial:SetParameter( self.TEXTURE_BLUR1,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bloomcombineMaterial:SetParameter( self.TEXTURE_BLUR2,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bloomcombineMaterial:SetParameter( self.TEXTURE_BLUR3,
    self.Rt3:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.bloomcombineRenderObj, self.bloomcombineMaterial);
  context:EndRenderPass();


  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.finalbloomMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.finalbloomMaterial:SetParameter(
    self.TEXTURE_BLOOM,
    self.Rt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.finalbloomMaterial:SetParameter(
    self.BLOOM_PARAM, self.bloomparam );
  self.finalbloomMaterial:SetParameter(
    self.GAMMA, self.gamma );
  self.finalbloomMaterial:SetParameter(
    self.MAXLUMINANCE, self.maxluminance );
  context:Draw(self.finalbloomRenderObj, self.finalbloomMaterial);
  context:EndRenderPass();
end

return bloomEffect;
