local apollocore = require "apollocore"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"

function apollocore.TextNode:RenderText()
  local maxWidth = 100000;
  local wordSpace = 5;
  self:InsertText();
  local textString = self:GetTextString();
  local glyph_list = textString:GetGlyphList();
  -- 生成顶点数据用于映射上面生成的图片
  local vertexstream = apollocore.VertexStream();
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_POSITION,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COLOR0,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 4);
  --创建索引流
  local indicesstream = apollocore.IndicesStream();
  indicesstream:SetIndicesType(
          apollocore.IndicesBufferEntity.IT_UINT16);

  -- 计算文字实际占用宽度
  local space = 0;
  local width = 0;
  for _, glyph in pairs(glyph_list) do
    width = width + glyph.size.x + space;
  end
  local x = -width / 2;
  local y = -self.Size:y() / 2;
  local startWidth = x;
  -- 初始化顶点
  local color = mathfunction.vector4(1.0, 1.0, 1.0, 1.0);
  local index = 0;
  for i, glyph in ipairs(glyph_list) do
    if i == 1 then
      if glyph.size.x > maxWidth then
        return;  --当文字框宽度无法显示第一个完整字符时，直接不执行渲染
      end
    end
    local  xpos = x + glyph.begin.x;
    local ypos = y - (glyph.size.y - glyph.begin.y);
    local w = glyph.size.x;
    local h = glyph.size.y;

    if not glyph.blank then
      -- lefttop
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos, ypos + h));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.x, glyph.uv.y));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
      -- leftbottom
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos, ypos));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.x, glyph.uv.w));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
      -- righttop
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w, ypos + h));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.z, glyph.uv.y));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
      -- rightbottom
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w, ypos));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.z, glyph.uv.w));
      vertexstream:PushVertexData(apollocore.ShaderEntity.ATTRIBUTE_COLOR0, color);
      -- 顶点数据
      indicesstream:PushIndicesData(0 + 4 * index);
      indicesstream:PushIndicesData(1 + 4 * index);
      indicesstream:PushIndicesData(2 + 4 * index);
      indicesstream:PushIndicesData(2 + 4 * index);
      indicesstream:PushIndicesData(1 + 4 * index);
      indicesstream:PushIndicesData(3 + 4 * index);

      index = index + 1;
    end
    --字间距和文字框的最大宽度，目前没有换行的功能，高度按照字体的大小来决定
    x = x + glyph.size.x + wordSpace;
    if x >= maxWidth + startWidth then
      break
    end
  end
  local render = self:GetComponent(apollocore.Node.CT_RENDER);
  render:ChangeVertexBuffer(vertexstream);
  render:ChangeIndexBuffer(indicesstream);
  render:SetParameter(apollocore.ShaderEntity.TEXTURE_DIFFUSE, textString:GetTextureEntity());
end

return apollocore.TextNode;