local EventDispatcher = require "bluecore.eventdispatcher"
local apollocore = require "apollocore"
local BD = require "bluecore.bluedefined"
local AR = require "augmentedreality"

local _fNativeUpdate = apollocore.IComponent.Update;

local _UpdateFunc = function(self, def)
  _fNativeUpdate(self, def);

  local staticID = self:GetContentPath();
  if EventDispatcher:HasCompListener(staticID) then
    local hasPlane = self:IsSetPos();
    local k = self.PlaneType;
    local HAS_PLANE_EVENT = BD.Event.VirtualEvent.HasPlane
    if hasPlane and EventDispatcher:HasEventListener(staticID, HAS_PLANE_EVENT) then
      local event = {
        staticID = staticID;
        eventType = HAS_PLANE_EVENT;
        params = k;
      };
      EventDispatcher:PushEvent(event);
    end
  end
end
rawset(AR.ARPlaneComponent, "Update", _UpdateFunc);
