
#include "common.inc"
#include "shadow.inc"

#ifndef LIGHTTOON_INC
#define LIGHTTOON_INC

float4 tex2DGamma(Texture2D tex,SamplerState samp, float2 uv, float gamma)
{
	return pow(tex.Sample(samp, uv).rgba, gamma);
}

float4 tex2D(Texture2D tex,SamplerState samp, float2 uv)
{
	return tex.Sample(samp, uv).rgba;
}

float3 AttenedLightColor(float attenuation,float basecolorstep,float halflambert)
{
#ifndef DirLight
  float3 orilightcolor = LIGHT_COLOR.xyz*attenuation;
  float3 passlightcolor = orilightcolor*halflambert;
  
  float  pureIntencity = max(0.001, (0.299*orilightcolor.r + 0.587*orilightcolor.g + 0.114*orilightcolor.b));
  
  float3 lightcolor = min (passlightcolor,passlightcolor/pureIntencity);
  
  return min(lightcolor.xyz,orilightcolor*basecolorstep);
#else
  return LIGHT_COLOR.xyz*attenuation;
#endif

}

void GetLightParam(float3 worldPos,out float3 outlightDir,out float3 outviewDir,out float outlightAtt)
{
  float3 lightDir = float3(0.0,0.0,0.0);
  float atten = 1.0;
#ifdef PointLight
  lightDir = LIGHT_POSITION.xyz - worldPos.xyz;
  float distanceSqr = max(dot(lightDir.xyz, lightDir.xyz),0.0001);
  
  half factor = distanceSqr * (LIGHT_RANGE_INV)* (LIGHT_RANGE_INV);
  float lightAtten = 1.0/factor;
  half smoothFactor = saturate(1.0 - factor);
  smoothFactor = smoothFactor * smoothFactor;
  atten = lightAtten * smoothFactor;
  
  lightDir.xyz = normalize(lightDir.xyz);
#elif DirLight
  lightDir = -LIGHT_GIVEN_DIRECTION.xyz;
  lightDir.xyz = normalize(lightDir.xyz);
#elif SpotLight  
  lightDir = LIGHT_POSITION.xyz - worldPos.xyz;
  float dis = sqrt(dot(lightDir.xyz, lightDir.xyz));
	float disAtten = clamp(dis * LIGHT_RANGE_INV, 0.0, 1.0);
	atten = (1.0 - disAtten) /  ( LIGHT_ATTENUATION.x + disAtten * LIGHT_ATTENUATION.y + disAtten * disAtten * LIGHT_ATTENUATION.z );
	float attenAngle = 1.0;
	lightDir.xyz = normalize(lightDir.xyz);
	attenAngle = clamp( 1.0 - ( LIGHT_INNER_DIFF_INV.x - dot(lightDir.xyz, -LIGHT_GIVEN_DIRECTION.xyz) ) * LIGHT_INNER_DIFF_INV.y, 0.0, 1.0 );
	atten *= attenAngle;
#endif
  outlightDir = lightDir;
  outlightAtt = atten;
  outviewDir = normalize( CAMERA_WORLDPOSITION.xyz - worldPos.xyz);
}
#endif