//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////





#SHADER_DEFINE VertexOutput

	FUNCTION_INPUT = 
	{
		{ SCREENSPACE_POSITION,		HIGH,	VEC4,	"in_ScreenPosition" },
		{ DEVICE_COORDINATE_Y_FLIP, HIGH,   FLOAT,  "in_Flip"},
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
	vec4 scale = vec4(
		1.0f,
		in_Flip,
		1.0f,
		1.0f
	);
	//return mul(scale, vertex);
	gl_Position = scale * in_ScreenPosition;
    //gl_Position = in_ScreenPosition;
#END_CODE
#END_DEFINE

#SHADER_DEFINE VertexColor
	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_COLOR0, 		HIGH,	VEC4,		"in_Color" },
	}
	FUNCTION_OUTPUT = 
  {
    { SURFACE_COLOR,	LOW,	VEC4,	"color" }
  }

#SHADER_CODE
  vec4 color = in_Color;
#END_CODE
#END_DEFINE

#SHADER_DEFINE FragmentOutput

	FUNCTION_INPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" }
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    gl_FragColor = in_SurfaceColor;
#END_CODE
#END_DEFINE



#SHADER_DEFINE DebugFragmentOutput

FUNCTION_INPUT = {
	{ COLOR,	LOW,	VEC3,	"color" }
}
FUNCTION_OUTPUT = {}

#SHADER_CODE
gl_FragColor = vec4(color,1.0);
#END_CODE
#END_DEFINE


#SHADER_DEFINE DebugFragmentOutputabc

FUNCTION_INPUT = {}
FUNCTION_OUTPUT = {}

#SHADER_CODE
gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
#END_CODE
#END_DEFINE




#SHADER_DEFINE FragmentConstantOutput

	FUNCTION_INPUT = {	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    gl_FragColor = vec4(1,1,1,1);
#END_CODE
#END_DEFINE

#SHADER_DEFINE DirectionFragmentShadowedOutput

	FUNCTION_INPUT = 
	{
    { LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
    { WORLDSPACE_NORMAL,         HIGH, VEC3,    "in_NormalWS"},
    { WORLDSPACE_POSITION,       HIGH, VEC4,   "in_PositionWS"},
    { SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
    { LIGHTSPACE_DEPTH,     HIGH, FLOAT,  "in_Depth"},
    { LIGHTSPACE_POSITION,    HIGH, VEC4,    "in_LightVertex"}
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    float m = 0.0035410088;
    vec3 l = normalize(-in_LightDirection);
    vec3 n = normalize(in_NormalWS);
    float cosTheta = dot(n,l);
    float bias = m * tan(acos(cosTheta));
    float shadow = 1.0;
	
    if (in_Depth + bias < in_LightVertex.z  )
    {
        shadow = 0.2 ; 
    }
   gl_FragColor = in_SurfaceColor * shadow;
#END_CODE
#END_DEFINE

#SHADER_DEFINE SpotFragmentShadowedOutput

	FUNCTION_INPUT = 
	{
    { LIGHT_VERTEX_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
    { WORLDSPACE_NORMAL,         HIGH, VEC3,    "in_NormalWS"},
    { WORLDSPACE_POSITION,       HIGH, VEC4,   "in_PositionWS"},
    { SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
    { LIGHTSPACE_DEPTH,     HIGH, FLOAT,  "in_Depth"},
    { LIGHTSPACE_POSITION,    HIGH, VEC4,    "in_LightVertex"}
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    float m = 0.0035410088;
    vec3 l = normalize(in_LightDirection);
    vec3 n = normalize(in_NormalWS);
    float cosTheta = dot(n,l);
    float bias = m * tan(acos(cosTheta));
    float shadow = 1.0;
	
    if (in_Depth + bias < in_LightVertex.z  )
    {
        shadow = 0.2 ; 
    }
    //gl_FragColor = in_SurfaceColor * shadow;
    gl_FragColor = vec4(in_Depth,0.0,0.0,1.0);
#END_CODE
#END_DEFINE

//͸ʰ͸Ӱͼ
#SHADER_DEFINE OpaqueShadowFragmentOutput

	FUNCTION_INPUT =  { }
	FUNCTION_OUTPUT = { }

#SHADER_CODE
	gl_FragColor = vec4(1.0,1.0,1.0,0.0);
#END_CODE
#END_DEFINE
