#SHADER_DEFINE DebugConePhysicsPosition

FUNCTION_INPUT =
{
	{ LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
	{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,		"in_Position" },
	{ CAMERA_VIEWPROJ,			HIGH,	MAT4,		"in_ViewPorj" },
	{ UNIFORM_DEBUGCONE,        LOW,    VEC2,       "in_ConeTrans"}
}

FUNCTION_OUTPUT =
{
	{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	{ WORLDSPACE_POSITION,		HIGH,	VEC4,		"out_PositionWS" },
}

#SHADER_CODE

vec4 out_PositionTemp = vec4(in_Position.x * in_ConeTrans.y, in_Position.y, in_Position.z * in_ConeTrans.y, 1.0);
vec4 out_PositionUD = vec4(out_PositionTemp.x, out_PositionTemp.y * in_ConeTrans.x * 0.5, out_PositionTemp.z, 1.0);
vec4 out_PositionWS = in_Transfrom * out_PositionUD;
vec4 out_Position = in_ViewPorj * out_PositionWS;
#END_CODE
#END_DEFINE