// 采样纹理的着色器
// 得到PBR需要用到的相关信息
#SHADER_DEFINE PBRClothTexture2DSampling

    FUNCTION_INPUT =
    {
				{ TEXTURE_ALDEBO,						NONE,			TEXTURE2D,		"albedoMap" },
				{ TEXTURE_AMR,              NONE,     TEXTURE2D,    "AoRoughnessMetallicMap"},
				{ ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
				{ TEXTURE_NORMAL,					NONE,			TEXTURE2D,		"normalMap" },
				{ WORLDSPACE_POSITION,		MEDIUM,		VEC3,					"WorldPos"},
				{ WORLDSPACE_NORMAL,			MEDIUM,		VEC3,					"Normal"},
				{ HAS_ALPHA,			HIGH,		FLOAT,					"Alpha"},
    }

    FUNCTION_OUTPUT =
    {
				{ ALBEDO_COLOR,					LOW,			VEC4,					"albedo" },
				{ METALLIC_VALUE,				HIGH,			FLOAT,				"metallic" },
				{ AO_VALUE,				HIGH,			FLOAT,				"ao" },
				{ ROUGHNESS_VALUE,			HIGH,			FLOAT,				"roughness" },
				{ TANGENTSPACE_NORMAL,	LOW,			VEC3,					"Normal_TangentSpace" },
				{	Base_Reflectivity,				LOW,			VEC3,					"F0"},
    }

#SHADER_CODE
	vec4 albedo = texture2D(albedoMap, in_Coordinate).rgba;
	albedo.rgb		 = pow(albedo.rgb, vec3(2.2));
  albedo.a = mix(1.0,albedo.a,Alpha);
    vec3 ao_roughness_metallic = texture2D(AoRoughnessMetallicMap,in_Coordinate).rgb;
    float ao = ao_roughness_metallic.r;
    float roughness = ao_roughness_metallic.g;
    float metallic = ao_roughness_metallic.b;
		vec3 Normal_TangentSpace;
		{
			vec3 tangentNormal_tmp = texture2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0;
			Normal_TangentSpace = normalize(tangentNormal_tmp);
		}
		vec3 F0 = vec3(0.04);
		F0 = mix(F0, albedo.rgb, metallic);
#END_CODE
#END_DEFINE


//---------------------------------------------------------------------------
//整合直接光照和环境光照的效果，输出到片元
#SHADER_DEFINE ClothFragmentOutput

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
			{ LIGHTING_AMBIENT,				LOW,	VEC3,		"light_Ambient" },
			{ ALBEDO_COLOR,					LOW,	VEC4,		"albedo" },
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE

		//光源对当前片元颜色的贡献
		vec3 color =  light_Specular+light_Diffuse+light_Ambient;

		// HDR tonemapping
		//color = color / (color + vec3(1.0));

		// gamma correct
		color = pow(color, vec3(1.0/2.2));
		gl_FragColor = vec4(color,albedo.a);

#END_CODE
#END_DEFINE

//整合直接光照和环境光照的效果，输出到片元（加阴影）
#SHADER_DEFINE ClothFragmentOutputShadow

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
			{ LIGHTING_AMBIENT,				LOW,	VEC3,		"light_Ambient" },
			{ WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
			{ WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
			{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
    const mediump float constant = 60.0;
    float expFactor = clamp(exp(constant * ( in_TexDepth - in_OrigDepth) ),0.0,1.0);

		//光源对当前片元颜色的贡献
		vec3 color =  (light_Specular+light_Diffuse)*expFactor+light_Ambient;

		// HDR tonemapping
		//color = color / (color + vec3(1.0));

		// gamma correct
		color = pow(color, vec3(1.0/2.2));
    
    gl_FragColor = vec4(color,albedo.a);

#END_CODE
#END_DEFINE

//-------------------------------------------------------------------------



//整合直接光照和环境光照的效果，输出到片元（画半透明阴影贴图）
#SHADER_DEFINE ClothFragmentOutputShadowTransparent

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
			{ LIGHTING_AMBIENT,				LOW,	VEC3,		"light_Ambient" },
			{ WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
			{ WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
    const mediump float constant = 60.0;
    float expFactor = clamp(exp(constant * ( in_TexDepth - in_OrigDepth )),0.0, 1.0 );

		//光源对当前片元颜色的贡献
		vec3 color =  (light_Specular+light_Diffuse)*expFactor+light_Ambient;

		// HDR tonemapping
		//color = color / (color + vec3(1.0));

		// gamma correct
		color = pow(color, vec3(1.0/2.2));
		gl_FragColor =  mix(vec4(vec3(1.0),0.0),vec4(color,0.5),expFactor);

#END_CODE
#END_DEFINE