#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_MaskMap = { "mask Color", TEXTURE2D, "white" },

[Keywords(CRED,CBLUE,CDEF)]
_keydef = {"keydef", FLOAT, "2.0"},
_edge0 = { "edge0", FLOAT, "0.3" },
_edge1 = { "edge1", FLOAT, "1" },
#END

#DEFTAG
ShaderName = "statetest"
RenderQueue = "Transparent+2"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile CRED CBLUE CDEF
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
	float2 maskuv : TEXCOORD1;
};

Texture2D _MainTex;
Texture2D _MaskMap;
SamplerState _MainSampler;
SamplerState _MaskMapSampler;

float _edge0;
float _edge1;

v2f vert(appdata v)
{
	v2f o;
	float4 pos;
	pos = float4(v.vertex.x,v.vertex.y,0.0,1.0);

	float2 tempuv = (v.vertex + 1.0)/2.0;
	o.maskuv = tempuv;	
	o.maskuv.y = 1.0 - tempuv.y;

	o.vertex = UniformNDC(pos);

	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	//The alpha of the face area is 1.0 and the occluded area is 0.0
	float bvtMaskColorAlpha = _MaskMap.Sample(_MaskMapSampler, i.uv).a;
	if(i.maskuv.x < 0.0 || i.maskuv.y < 0.0 || i.maskuv.x > 1.0 || i.maskuv.y > 1.0)
		bvtMaskColorAlpha = 1.0;

	bvtMaskColorAlpha = smoothstep(_edge0, _edge1, bvtMaskColorAlpha);

	//Set alpha of the face occlusion area to 1.0
	bvtMaskColorAlpha = 1.0 - bvtMaskColorAlpha;

	float4 mainColor = _MainTex.Sample(_MainSampler, i.maskuv);
	mainColor.a = bvtMaskColorAlpha;
#ifdef CRED
	outColor = float4(1.0,0.0,0.0,1.0);
#endif

#ifdef CBLUE
	outColor = float4(0.0,0.0,1.0,bvtMaskColorAlpha);
#endif

#ifdef CDEF
	outColor = mainColor;
#endif

}
ENDCG
#END
