local Object = require "classic"
local soundplayer = require "soundplayer"
local soundercontrol = Object:extend();
local defined = require "lightgame.manipulatepartical.defined"

local soundDetectLoop = defined.soundLoopCount.SoundDetectLoop;
local soundSilenceLoop = defined.soundLoopCount.SoundSilenceLoop;
function soundercontrol:new()
  self.soundplayerDetect = soundplayer();
  self.soundplayerSilence = soundplayer();
  if(soundDetectLoop>1)
  then
    self.loopDectect = 1;
  else
    self.loopDectect = 0;
  end
  
  if(soundSilenceLoop>1)
  then
   self.loopSilence = 1;
  else
   self.loopSilence = 0;
  end
    
 
  self.loopDectectCount = soundDetectLoop;
  self.loopSilenceCount = soundSilenceLoop;
  self.first = false;
end

function soundercontrol:Parseconfig(config)
   local res = self.soundplayerDetect:LoadSound(config.detectPath);
   res = res and  self.soundplayerSilence:LoadSound(config.silencePath);
   return res;
end

function soundercontrol:Setup(detectSound,silenceSound)
    local res = self.soundplayerDetect:LoadSound(detectSound);
   res = res and  self.soundplayerSilence:LoadSound(silenceSound);
   return res;
end




function soundercontrol:Play( soundtype)
  if(defined.soundType.SoundDectect==soundtype and (not self.soundplayerDetect:isPlaying()) and  (self.loopDectectCount>0 or  self.loopDectect==0 ))
  then
     self.soundplayerSilence:StopSound();
     self.soundplayerDetect:PlaySound( self.loopDectect);
     self.loopDectectCount =  self.loopDectectCount-1;
     self.loopSilenceCount = soundSilenceLoop;
   
  elseif(defined.soundType.SoundSilence==soundtype and (not self.soundplayerSilence:isPlaying()) and  (self.loopSilenceCount>0 or  self.loopSilence==0 ) )
   --elseif(defined.soundType.SoundSilence==soundtype and self.first == false)
  then 
     self.soundplayerDetect:StopSound();
     self.soundplayerSilence:PlaySound( self.loopSilence);
     self.first = true;
     self.loopSilenceCount = self.loopSilenceCount-1;
     self.loopDectectCount = soundDetectLoop;
  end
end

function soundercontrol:Stop()
    --return;
    self.soundplayerDetect:StopSound();
    self.soundplayerSilence:StopSound();
end

function soundercontrol:GetVolume()
  return soundplayer.GetVolume();
end



return soundercontrol;