
local _DEBUG = true;

local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local venusblendshape = require "venusblendshape"

local main = {}

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;
  
  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;
  
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("FPS "..fps);
  end
  return def;
end

function main:ReceiveTransMatrix(RT_m44)
  LOG("main:ReceiveTransMatrix");
	venusblendshape.bs:ReceiveTransMatrix(RT_m44);
	_rot = mathfunction.Quaternion();
	_pos = mathfunction.vector3();
	_rot = RT_m44:ToQuaternion();
	_pos = RT_m44:ToTransform();
	--venusblendshape.model1:SetLocalRotation(_rot);
    --venusblendshape.model1:SetLocalPosition(_pos);
end
  
function main:ReceiveLookAtPoints(lookat_v3)
  LOG("main:ReceiveLookAtPoints");
  look_from = mathfunction.vector3(0.0,0.0,1.0);
  --lookat_v3 = mathfunction.vector3(0.0,0.0,0.0);
  --venusblendshape.bs:ReceiveLookAtPoints(lookat_v3);
  local quat = mathfunction.Mathutility:AxisToAxis(look_from,lookat_v3);
  if venusblendshape.bsmodel["left_eye"]~=nil then
	venusblendshape.model[venusblendshape.bsmodel["left_eye"]]:SetLocalRotation(quat);
  end
  if venusblendshape.bsmodel["right_eye"]~=nil then
    venusblendshape.model[venusblendshape.bsmodel["right_eye"]]:SetLocalRotation(quat);
  end	
end

function main:ReceiveBlendShapeDatas(weights_dict)
  LOG("main:ReceiveBlendShapeDatas");
  --weights_dict = venusblendshape.bs:ReceiveBlendShapeDatas();
	for meshesKey, meshesValue in pairs(venusblendshape.bsmodel) do
		if weights_dict[meshesKey] ~= nil then
			local idx = meshesValue;
			venusblendshape.weights[idx] = weights_dict[meshesKey];
		else 
			venusblendshape.weights[meshesValue] = 0;
		end
	end
	venusblendshape.bs:ReceiveWeights(venusblendshape.weights);
		
	local quat2 = mathfunction.Mathutility:YawPitchRoll(math.rad(0.0),math.rad(venusblendshape.tongue_rot*venusblendshape.weights[venusblendshape.bsmodel["jawOpen"]]),math.rad(0.0));
	if venusblendshape.bsmodel["tongue"]~= nil then
		venusblendshape.model[venusblendshape.bsmodel["tongue"]]:SetLocalRotation(quat2);
    end
	if venusblendshape.bsmodel["lower_teeth"]~=nil then
		venusblendshape.model[venusblendshape.bsmodel["lower_teeth"]]:SetLocalRotation(quat2);
	end
	if (venusblendshape.bsmodel["jawLeft"]~= nil and venusblendshape.bsmodel["jawRight"]~= nil and venusblendshape.bsmodel["jawForward"] ~= nil) then
		local trans = mathfunction.vector3(-venusblendshape.tongue_trans_left*		venusblendshape.weights[venusblendshape.bsmodel["jawLeft"]]+venusblendshape.tongue_trans_right*venusblendshape.weights[venusblendshape.bsmodel["jawRight"]],0.0,venusblendshape.tongue_trans_forward*venusblendshape.weights[venusblendshape.bsmodel["jawForward"]]);
		if venusblendshape.model["lower_teeth"]~= nil then
			venusblendshape.model["lower_teeth"]:SetLocalPosition(venusblendshape.trans_lowteeth+trans);
		end
		if venusblendshape.model["tongue"] ~= nil then
			venusblendshape.model["tongue"]:SetLocalPosition(venusblendshape.trans_tongue+trans);
		end
	end
    local vertexstream = venusblendshape.bs:GetBlendShape();
    venusblendshape.model_face.render:FlushVertexBuffer(vertexstream);
end

function main:CreateCameras(near, far, pos, lookat, up)  
  self.maincamera = apollonode.CameraNode();--新建摄像机
	self.maincamera:CreatePerspectiveProjection(near, far);--设置摄像机
	self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:SetClearColor(mathfunction.Color(0.5,0.5,0.5,1));
  self.maincamera:Activate();--激活主摄像机
  
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_A,--标记作用，主要用于底层资源共享
      apolloengine.Framework:GetViewport(),--视口大小
      apolloengine.Framework:GetResolution()));--分辨率
  self.outputtexture = self.rendertarget:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
				apolloengine.TextureBufferMetadata(apolloengine.Framework:GetResolution()));
  self.rendertarget:CreateResource();
  
    --创建一个渲染到rt的摄像机
  self.outputcamera = apollonode.CameraNode();
	self.outputcamera:CreatePerspectiveProjection(near, far);
	self.outputcamera:LookAt(pos, lookat, up);
  self.outputcamera:AttachRenderTarget(self.rendertarget);
  --self.outputcamera:EraseLayerMask(apolloengine.LayerMask.MC_MASK_DEFAULT_LAYER);--设置渲染mask
  self.outputcamera:SetSequence(
    self.maincamera:GetSequence() + 1);--将渲染摄像机的顺序设置为主摄像机之后渲染
  self.texturestream = apolloengine.TextureStream();
end

function main:Initialize()
  _COROUTINES_ON();
  
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;
  
  self:CreateCameras(1, 1000,
        mathfunction.vector3(0,0,1.0),
		mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,1,0));
		--venusblendshape:Initialize("docs:Girl_blendshape/blendshapemeshes.json");
	venusblendshape:Initialize("docs:girlHead/blendshapemeshes.json");
  
  self.count = 0;
  self.count1= 0;
  self.mat = mathfunction.Matrix44();
  self.mat:SetIdentity();
  self._rot = mathfunction.Quaternion();
  self._pos = mathfunction.vector3();
  --self.bs:ReceiveRT(self.mat,self._rot,self._pos);
  --self.model1:SetLocalRotation(self._rot);
  --self.model1:SetLocalPosition(self._pos);
  ------Test-------
  --self._pos = self.mat:ToTransform();
  --self._rot = self.mat:ToQuaternion();
  --self:ReceiveTransMatrix(self.mat);
  local modelconfig = venusjson.LaodJsonFile("docs:Girl_blendshape/test_weight_1.json");
  --venusblendshape.bs:ReceiveBlendShapeDatas(weights_dict);
  self:ReceiveBlendShapeDatas(modelconfig);
  
  
  --a11 = pos.data[0];
  --a21 = pos[2];
  venuscore.ITimerSystem:RegisterTimer(self._Agent, 1, "Ontime");--注册定时器事件
  --apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");

  LOG("initialize done");
  _COROUTINES_OFF();
  return true;
end

function main:Ontime()
  self:_Running();
end

function main:_Running()
    mytable={};
  mytable["mouthFrownRight"] = 1.0;
  local modelconfig = venusjson.LaodJsonFile("docs:Girl_blendshape/test_weight_1.json");
  --local modelconfig = venusjson.LaodJsonFile("docs:girlHead/test_weight_1.json");
  look = {};
  --for i=1, 3 do
  --  look[i] = math.random();
  --end
  look[1] = -1.0; look[2] = 1.0; look[3] = 6;
  look[4] = -1; look[5] = 0; look[6] = 6;
  look[7] = -1; look[8] = -1; look[9] = 6;
  look[10] = 0; look[11] = -1; look[12] = 6;
  look[13] = 1; look[14] = -1; look[15] = 6;
  look[16] = 1; look[17] = 0; look[18] = 6;
  look[19] = 1; look[20] = 1; look[21] = 6;
  look[22] = 0; look[23] = 1; look[24] = 6;
  look[25] = 0; look[26] = 0; look[27] = 6;
  if(self.count1 == 3)
  then
    self.count1 = -5;
  else
    self.count1 = self.count1 + 1;
  end
  look_at = mathfunction.vector3(look[(self.count1+5)*3+1],look[(self.count1+5)*3+2],look[(self.count1+5)*3+3]);
  self:ReceiveLookAtPoints(look_at);
  self.mat = mathfunction.Matrix44();
  self.mat:SetIdentity();
  --venusblendshape:blendshape_update(self.mat,modelconfig,look_at);
  
  
  _rot = mathfunction.Quaternion();
  _pos = mathfunction.vector3();
  --self:ReceiveTransMatrix(self.mat);
  --lookat_v3 = mathfunction.vector3(0.0,0.0,0.0);
  --weights_dict = {};
  local modelconfig = venusjson.LaodJsonFile("docs:Girl_blendshape/test_weight_1.json");
  --venusblendshape.bs:ReceiveBlendShapeDatas(weights_dict);
  self:ReceiveBlendShapeDatas(modelconfig);
end

function main:Update()
  self:_Running();
end

function main:Abort()
  venuscore.ITimerSystem:UnregisterTimer(self._Agent, "Ontime");
  --apolloengine.Framework:RemoveTouchCallback(self._Agent, "OnTouch");
  --apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end


return main;