local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local HandPutUpBehavior = venuscore.VenusBehavior:extend("HandPutUpBehavior"); 
local STATE_STOP = 0;
local STATE_PLAY = 1;

function HandPutUpBehavior:new()  
  self.LeftHandAnimation = nil
  self.RightHandAnimation = nil
  self.Camera = nil;
  self.EffectAudio = nil;
  self.StarOffset = mathfunction.vector3(0.1,0.1,0.1);
  self.stateLeft = STATE_STOP;
  self.stateRight = STATE_STOP;
end

function HandPutUpBehavior:_OnAwake()
end

function HandPutUpBehavior:Play(isLeft)
  if isLeft then
    if self.LeftHandAnimation and self.stateLeft ~= STATE_PLAY then
      local renderCmp = self.LeftHandAnimation:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
      renderCmp:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      --self.LeftHandAnimation:Reset();
      self.LeftHandAnimation:Play();
      self.stateLeft = STATE_PLAY;
      if self.EffectAudio ~= nil then
        self.EffectAudio:Play();
      end
    end
  else
    if self.RightHandAnimation and self.stateRight ~= STATE_PLAY then
      local renderCmp = self.RightHandAnimation:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
      renderCmp:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      --self.RightHandAnimation:Reset();
      self.RightHandAnimation:Play();
      self.stateRight = STATE_PLAY;
      if self.EffectAudio ~= nil then
        self.EffectAudio:Play();
      end
    end
  end
end

function HandPutUpBehavior:Stop(isLeft)
  if isLeft then
    if self.LeftHandAnimation and self.stateLeft ~= STATE_STOP then
      self.LeftHandAnimation:Reset();
      self.LeftHandAnimation:Stop();
      local renderCmp = self.LeftHandAnimation:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
      renderCmp:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      self.stateLeft = STATE_STOP;
    end
  else
    if self.RightHandAnimation and self.stateRight ~= STATE_STOP then
      self.RightHandAnimation:Reset();
      self.RightHandAnimation:Stop();
      local renderCmp = self.RightHandAnimation:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
      renderCmp:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      self.stateRight = STATE_STOP;
    end
  end
end

function HandPutUpBehavior:UpdatePosition(pos,isLeft)
  if self.Camera ~= nil then
    local offset = (self.Camera:GetPosition() - pos):Normalize() * self.StarOffset;
    pos = pos + offset;
  end
  if isLeft then
    if self.LeftHandAnimation and self.stateLeft == STATE_PLAY then
      local trans = self.LeftHandAnimation:GetHostNode():GetComponent(apolloengine.Node.CT_TRANSFORM);
      trans:SetWorldPosition(pos);
    end
  else
    if self.RightHandAnimation and self.stateRight == STATE_PLAY then
      local trans = self.RightHandAnimation:GetHostNode():GetComponent(apolloengine.Node.CT_TRANSFORM);
      trans:SetWorldPosition(pos);
    end
  end 
end

function HandPutUpBehavior:GetStarOffset()
    return self.StarOffset
end

function HandPutUpBehavior:SetStarOffset(value)
    self.StarOffset = value
end

HandPutUpBehavior:MemberRegister("LeftHandAnimation",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.FrameAnimationComponent:RTTI()
));

HandPutUpBehavior:MemberRegister("RightHandAnimation",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.FrameAnimationComponent:RTTI()
));

HandPutUpBehavior:MemberRegister("Camera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.CameraComponent:RTTI())); 

HandPutUpBehavior:MemberRegister("StarOffset",
  venuscore.ScriptTypes.FloatArrayType(
      3,
      HandPutUpBehavior.GetStarOffset,
      HandPutUpBehavior.SetStarOffset
));
HandPutUpBehavior:MemberRegister("EffectAudio",
    venuscore.ScriptTypes.ReferenceType(
      apolloengine.AudioComponent:RTTI()
));
return HandPutUpBehavior;