local vc = require "venuscore"
local ae = require "apolloengine"
local mf = require "mathfunction"
local cv = require "computervisionfunction"

local FeedFaceSkinRender = vc.VenusBehavior:extend("FeedFaceSkinRender"); 

local dtSize = cv.GPUSegmentComponent.mlRectSize
local dtPosition = cv.GPUSegmentComponent.mlRectPosition
local dtPivot = cv.GPUSegmentComponent.mlRectPivot
local dtRoll = cv.GPUSegmentComponent.mlRectRoll;

function FeedFaceSkinRender:new()
end

function FeedFaceSkinRender:_OnUpdate(delta)
  local render = self.render
  local gpuSeg = self.Node:GetComponent(ae.Node.CT_CV_GPUSEGMENT);
  local cpuSeg = self.Node:GetComponent(ae.Node.CT_CV_SEGMENT);
  if render == nil or gpuSeg == nil then
    return
  end

  if cpuSeg ~= nil then
  end

  local fgTex = gpuSeg:GetMask()
  local bgTex = gpuSeg:GetTexture()
  local data = gpuSeg:GetData();
  local bgSize = gpuSeg:GetDetectSize()
  local skinRects = gpuSeg:GetFaceSkins()

  if  fgTex == nil or bgTex == nil or data == nil or 
      bgSize == nil or skinRects == nil then
    return
  end
  
  local texPos = data[dtPosition];
  local texSize = data[dtSize];
  local texPivot = data[dtPivot];
  local texRoll = data[dtRoll];
  if texPos == nil or texSize == nil or texPivot == nil or texRoll == nil then
    return
  end
  --WARNING(string.format("SUNTYLOG: fg pos (%f %f)", texPos[1], texPos[2]))
  --WARNING(string.format("SUNTYLOG: fg size (%f %f)", texSize[1], texSize[2]))
  --WARNING(string.format("SUNTYLOG: bg size (%f %f)", bgSize:x(), bgSize:y()))
  --WARNING(string.format("SUNTYLOG: fg pivot (%f %f)", texPivot[1], texPivot[2]))
  --WARNING(string.format("SUNTYLOG: fg roll (%f)", texRoll[1]))
  --x y w h
  local FgRect = mf.vector4(
    texPos[1],
    texPos[2], 
    texSize[1],
    texSize[2]
  )
  local normSkinRects = {}
  for i = 1, #skinRects do
    local skinRect = skinRects[i]
    table.insert(
      normSkinRects,
      mf.vector4(
        skinRect[1] / bgSize:x(),
        skinRect[2] / bgSize:y(),
        skinRect[3] / bgSize:x(),
        skinRect[4] / bgSize:y()
      )
    )
  end
  
  local FgPivot = mf.vector2(
    texPivot[1],
    texPivot[2]
  )


  if fgTex then
    render:SetParameter("_FgTex", fgTex)
  end
  if bgTex then
    render:SetParameter("_BgTex", bgTex)
  end
  if FgRect then
    render:SetParameter("_FgRect", FgRect)
  end
  if #normSkinRects >= 4 then
    for i = 1, 4 do
      skinrender:SetParameter("_SkinRect" .. tostring(i), normSkinRects[i])
    end
  end
  if FgPivot then
    render:SetParameter("_FgPivot", FgPivot)
  end
  if bgSize then
    render:SetParameter("_VideoSize", bgSize)
  end
  if texRoll then
    render:SetParameter("_Roll", mf.vector1(texRoll[1]))
  end
  
end

FeedFaceSkinRender:MemberRegister(
    "render",
    vc.ScriptTypes.ReferenceType(ae.RenderComponent:RTTI())
);

return FeedFaceSkinRender;