local apolloengine  = require "apolloengine"
local apollonode    = require "apolloutility.apollonode"
local apolloDefine = require "apolloutility.defiend"
local venuscore = require "venuscore"

local AudioStretch = {}

function AudioStretch:Initialize(scene)
    self.node = nil;
    self.audiocomponent = nil;
    self.path = "";
    self.speed = 0.0;
    self.isInit = false;
end 

function AudioStretch:CreartAudioStretch(cutterScene)
    if cutterScene == nil then
        return false
    end
    if not self.isInit then
        LOG("AudioStretch:CreartAudioStretch")        
        self.node = cutterScene:CreateNode(apolloengine.Node.CT_NODE);
        self.node:SetName("AudioStretch");
        local sceneid = self.node:GetHostScene():GetStaticID();        
        self.audiocomponent = self.node:CreateComponent(apolloengine.Node.CT_AUDIO_PLAYER)
        self.audiocomponent:SetSceneID(sceneid);
        self.audiocomponent.Mode = 3;
        self.audiocomponent:SetDriverType(2);
        self.audiocomponent.loop = false;
        self.isInit = true;
    end
    return true;
end

function AudioStretch:SetParam(file,value)
    if not self.isInit then
        return false;
    end
    self.path = file;
    self.speed = value
    return true;
end

function AudioStretch:Start()
    if(self.path ~= "" and self.isInit) then
        self.audiocomponent:setSpeed(self.speed);
        self.audiocomponent.path = self.path;
        self.audiocomponent:Play();
        return true;
    end
    return false;
end

function AudioStretch:Stop()
    if not self.isInit then
        return false;
    end
    return self.audiocomponent:Stop();
end

function AudioStretch:Clear(cutterScene)
    if self.isInit then
        LOG("AudioStretch:Clear")
        self.isInit = false;
        self.audiocomponent:Stop();
        self.audiocomponent:SetDriverType(1);
        if not venuscore.isNil(self.node) then  --防止Node重复删除(因为删除父Node会递归删除子Node)
          cutterScene:DeleteNode(self.node);
        end
        self.node = nil;
        self.audiocomponent = nil;
        self.path = "";
        self.speed = 0.0;
    end
    return true;
end

return AudioStretch;