local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local facecute = require "facecute"
local faceinfo = require "videodecet.faceinfo";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
require "utility"


local faceliftMicroShaping  = {}


EnumTableThinFace = 
{ 
    "TF_FACE",          --瘦脸
    "TF_EYE",           --大眼
    "TF_NARROWFACE",    --窄脸
    "TF_LENGCHIN",          --下巴长短
    "TF_THINNOSE",              --瘦鼻
    "TF_LENGNOSE",              --鼻子长短
    "TF_OPENCANTHUS",              --开眼角
    "TF_ANGLECANTHUS",              --眼角角度
    "TF_EYEDIS",              --眼距
    "TF_MOUTH",              --嘴型
    "TF_HAIRLINE",              --发际线
    "TF_HUMPNOSE",              --侧脸隆鼻
    "TF_LENGPHILTRUM",              --人中长短
    "TF_MACINTOSH"             --苹果肌
}


function faceliftMicroShaping:Initialize(camera)
  self.post = apollonode.PostEffect();
  self.post:CreateResource("comm:script/apolloutility/posteffect/facelift/pfaceliftingMicroShaping.lua");
  
  self.resolution = apolloengine.Framework:GetResolution();
  self.aspect_ratio = self.resolution:y() / self.resolution:x();
  
  self.post:RegisterParameter("UNIFORM_RATIOASPECT", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_FACESNUM", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_LEFT_EYES", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_RIGHT_EYES", "comm:documents/material/biggereyesMcroShaping.material");
  
  self.post:RegisterParameter("UNIFORM_FACECOEF", "comm:documents/material/biggereyesMcroShaping.material");                       
  self.post:RegisterParameter("UNIFORM_EYE_LARGE", "comm:documents/material/biggereyesMcroShaping.material");     
  self.post:RegisterParameter("UNIFORM_FACE_NARROW", "comm:documents/material/biggereyesMcroShaping.material");  
  self.post:RegisterParameter("UNIFORM_CHIN_LENG", "comm:documents/material/biggereyesMcroShaping.material");   
  self.post:RegisterParameter("UNIFORM_NOSE_NARROW", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_NOSE_LENG", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_CANTHUS_OPEN", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_CANTHUS_ANGLE", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_EYE_DIS", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_MOUTH", "comm:documents/material/biggereyesMcroShaping.material");  
  self.post:RegisterParameter("UNIFORM_MACINTOSH", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_LINE_HAIR", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_NOSE_HUMP", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_NOSE_HUMP_RATE", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_PHILTRUM_LENG", "comm:documents/material/biggereyesMcroShaping.material");    
  self.post:RegisterParameter("UNIFORM_CHINCOEF", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_LEFT_PTS", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_RIGHT_PTS", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_FOREHEAD", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_NOSE", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_MOUSE", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_CHIN", "comm:documents/material/biggereyesMcroShaping.material");
  self.post:RegisterParameter("UNIFORM_FACES_BOX", "comm:documents/material/biggereyesMcroShaping.material");
  
  local  facePara1 = mathfunction.vector2array();
  local  facePara2 = mathfunction.vector2array();
  local  mousePara0 = mathfunction.vector2array();
  

  self.post:UNIFORM_RATIOASPECT(mathfunction.vector1(self.aspect_ratio));
  
  self.tableTF = CreatEnumTable( EnumTableThinFace ) ;
  
  --参数列表
  self.coefTable = CreatCoefTable(EnumTableThinFace);
  
  self.t = 0;
  self.camera = camera
  camera:AttachPostEffect(self.post);
  
  --测试cpu计算关键点
  apolloengine.ShaderEntity.POINT_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"POINT_COLOR");
  self.pointrender = apollonode.PointNode();
  local keypointcount = 106;
  self.pointrender:CreateResource(keypointcount,mathfunction.vector4(0,1,0,1),"comm:documents/material/pointrender.material");
  self.pointrender:SetShow(false);
  renderqueue:After(self.pointrender); 

  
end

function faceliftMicroShaping:Release()
  if self.camera ~= nil then
    self.camera:DetachPostEffect(self.post)
    self.post = nil
    self.camera = nil;
  end
end


function faceliftMicroShaping:GetVector2dLength(vec)
  return math.sqrt(vec:x() * vec:x() + vec:y() * vec:y());
end


function faceliftMicroShaping:GetDistance(src, dst)
  local dx = src[1] - dst[1];
  local dy = src[2] - dst[2];
  return math.sqrt(dx * dx + dy * dy);
end


function faceliftMicroShaping:arrayToVec2(pt)
  return mathfunction.vector2(pt[1], pt[2]);
end


function faceliftMicroShaping:GetBoundingBox(keypoints, paddingRatio)
  local min_x =  1;
  local max_x = -1;
  local min_y =  1;
  local max_y = -1;

  for id, pt in pairs(keypoints) do
    min_x = math.min(min_x, pt[1]);
    max_x = math.max(max_x, pt[1]);
    min_y = math.min(min_y, pt[2]);
    max_y = math.max(max_y, pt[2]);
  end

  width  = max_x - min_x;
  height = max_y - min_y;

  min_x = min_x - paddingRatio * width;
  max_x = max_x + paddingRatio * width;
  min_y = min_y - paddingRatio * height;
  max_y = max_y + paddingRatio * height;

  return mathfunction.vector4(min_x, max_x, min_y, max_y);
end

--更新的算法
function faceliftMicroShaping:_UpdateFaceKeypoints1(currentPoint, delta)
  if currentPoint == nil then
    LOG("currentPoint is nil(type1) !");
    return currentPoint, 0;
  end
  if delta < 0.01 then
    return currentPoint, 0;
  end
  local positionToUse = currentPoint;
  local curNose = {};
  table.insert(curNose,0);
  table.insert(curNose,0);
  curNose[1] = self.keypoints[47][1];   
  curNose[2] = self.keypoints[47][2];   
  local curChin = {};
  table.insert(curChin,0);
  table.insert(curChin,0);
  local rightF = {};
  table.insert(rightF,0);
  table.insert(rightF,0);
  local leftF = {};
  table.insert(leftF,0);
  table.insert(leftF,0);
  local targetleftF = {};
  table.insert(targetleftF,0);
  table.insert(targetleftF,0);
  local targetrightF = {};
  table.insert(targetrightF,0);
  table.insert(targetrightF,0);
  local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);

  local curRadius = face_width*1.0;
  local normalScale = 1.0 - delta*0.1;
   --脸两侧左右的点9,23
  leftF[1] = self.keypoints[10][1];   
  leftF[2] = self.keypoints[10][2];   
  targetleftF[1] = curNose[1] + (leftF[1] - curNose[1]) * normalScale ;
  targetleftF[2] = curNose[2] + (leftF[2] - curNose[2]) * normalScale ;
  local leftFplus = self:faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
  --LOG("positionToUse111111111111111111111111111111111111-----x"..leftFplus[1].."         y"..leftFplus[2]);
  positionToUse[1] = positionToUse[1] + leftFplus[1];
  positionToUse[2] = positionToUse[2] + leftFplus[2];
  --LOG("positionToUse222222222222222222222222222222222222-----x"..positionToUse[1].."         y"..positionToUse[2]);
--
  rightF[1] = self.keypoints[24][1];   
  rightF[2] = self.keypoints[24][2];   
  targetrightF[1] = curNose[1] + (rightF[1] - curNose[1]) * normalScale ;
  targetrightF[2] = curNose[2] + (rightF[2] - curNose[2]) * normalScale ;
  local rightFplus = self:faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
  positionToUse[1] = positionToUse[1] + rightFplus[1];
  positionToUse[2] = positionToUse[2] + rightFplus[2];
 
--收下巴点位13，19
  local chin = self.keypoints[17];
  local chinCenter = {};
  table.insert(chinCenter,0);
  table.insert(chinCenter,0);

  chinCenter[1] = curNose[1] + (chin[1] - curNose[1]) * 0.7;
  chinCenter[2] = curNose[2] + (chin[2] - curNose[2]) * 0.7;
  
  curRadius = face_width*1.2;

  leftF = self.keypoints[14];
  targetleftF[1] = chinCenter[1] + (leftF[1] - chinCenter[1]) *  normalScale;
  targetleftF[2] = chinCenter[2] + (leftF[2] - chinCenter[2]) *  normalScale;
  leftFplus = self:faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
  positionToUse[1] = positionToUse[1] + leftFplus[1];
  positionToUse[2] = positionToUse[2] + leftFplus[2];

  rightF = self.keypoints[20];
  targetrightF[1] = chinCenter[1] + (rightF[1] - chinCenter[1]) *  normalScale;
  targetrightF[2] = chinCenter[2] + (rightF[2] - chinCenter[2]) *  normalScale;
  rightFplus = self:faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
  positionToUse[1] = positionToUse[1] + rightFplus[1];
  positionToUse[2] = positionToUse[2] + rightFplus[2];
    
  return positionToUse, 1;
end


--眼睛
function faceliftMicroShaping:_UpdateFaceKeypoints2(currentPoint, center, radius, delta)
  if currentPoint == nil then
    LOG("currentPoint is nil(type2) !");
    return currentPoint, 0;
  end
  
   if delta > -0.0001 and delta < 0.0001 then
    return currentPoint, 0;
  end
    --需要参数，左右嘴角点，aspectRatio，currentPoint，center
    if delta >= 0.0001 or delta <= -0.0001 then
        local positionToUse = currentPoint;
        local test = currentPoint;
        local pt1 = {};
        local pt2 = {};
        
        --self.aspect_ratio = 1.764705;
        --delta = 0.3334;
        --radius = 0.1376;
        
        table.insert(pt1,positionToUse[1]);
        table.insert(pt1,positionToUse[2]*self.aspect_ratio);
        table.insert(pt2,center[1]);
        table.insert(pt2,center[2]*self.aspect_ratio);
        
        
        --float test1 = positionToUse.y*1.764705;
        --float test2 = leftEyes[i*11+9].y*1.764705;

        local dis_eye = self:GetDistance(pt1, pt2);

        if dis_eye <= radius then
           local alpha = 1.0 - math.pow(dis_eye/radius,delta);
           --alpha = 0.7;
           --LOG("dis_eye-------------------------------------------------------"..dis_eye);
           --LOG("radius--------------------------------------------------------"..radius);
           --LOG("delta---------------------------------------------------------"..delta);
          -- LOG("alpha---------------------------------------------------------"..alpha);
           positionToUse[1] = positionToUse[1] + (positionToUse[1] - center[1]) * alpha;
           positionToUse[2] = positionToUse[2] + (positionToUse[2] - center[2]) * alpha;
           
           --local test1 = currentPoint;
           --test1[1] = positionToUse[1] - currentPoint;
           
           return positionToUse, 1;
        else
           return currentPoint, 0;
        end
    end
end

--窄脸
function faceliftMicroShaping:_UpdateFaceKeypoints3(currentPoint, delta,index)
      if currentPoint == nil then
        LOG("currentPoint is nil(type3) !");
        return currentPoint, 0;
      end
      if delta < 0.01 then  
        return currentPoint, 0;
      end
      local positionToUse = currentPoint;
      local curNose = {};
      table.insert(curNose,0);
      table.insert(curNose,0);
      curNose[1] = self.keypoints[47][1];   
      curNose[2] = self.keypoints[47][2];   
 
      local leftF = {};
      table.insert(leftF,0);
      table.insert(leftF,0);
      local targetleftF = {};
      table.insert(targetleftF,0);
      table.insert(targetleftF,0);
   
      local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
      
      local curRadius = face_width*0.2;
      local normalScale = 1.0 - delta*0.02;
      
      leftF[1] = self.keypoints[index][1];   
      leftF[2] = self.keypoints[index][2];   
      targetleftF[1] = curNose[1] + (leftF[1] - curNose[1]) * normalScale ;
      targetleftF[2] = curNose[2] + (leftF[2] - curNose[2]) * normalScale ;
      local leftFplus = self:faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
      --LOG("positionToUse111111111111111111111111111111111111-----x"..leftFplus[1].."         y"..leftFplus[2]);
      positionToUse[1] = positionToUse[1] + leftFplus[1];
      positionToUse[2] = positionToUse[2] + leftFplus[2];
        
      return positionToUse, 1;
end

--下巴长短
function faceliftMicroShaping:_UpdateFaceKeypoints4(currentPoint, delta,index,k,curChin,targetchin,normalScale,face_width)
      if currentPoint == nil then
        LOG("currentPoint is nil(type4) !");
        return currentPoint, 0;
      end

      local positionToUse = currentPoint;
    
      local leftF = {};
      table.insert(leftF,0);
      table.insert(leftF,0);
      local targetleftF = {};
      table.insert(targetleftF,0);
      table.insert(targetleftF,0);
      
      local curRadius = face_width*0.2;
  
      leftF[1] = self.keypoints[index][1];   
      leftF[2] = self.keypoints[index][2];   
      targetleftF[1] = leftF[1] + (targetchin[1] - curChin[1]) * normalScale*k ;
      targetleftF[2] = leftF[2] + (targetchin[2] - curChin[2]) * normalScale*k ;
      local leftFplus = self:faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
      --LOG("positionToUse111111111111111111111111111111111111-----x"..leftFplus[1].."         y"..leftFplus[2]);
      positionToUse[1] = positionToUse[1] + leftFplus[1];
      positionToUse[2] = positionToUse[2] + leftFplus[2];
        
      return positionToUse, 1;
end
--瘦鼻
function faceliftMicroShaping:_UpdateFaceKeypoints5(leftF,rightF,curRadius,normalScale)
   if leftF == nil or  rightF == nil  then
      LOG("currentPoint is nil(type5) !");
    end
   
    local targetleftF = {};
    table.insert(targetleftF,0);
    table.insert(targetleftF,0);
    local targetrightF = {};
    table.insert(targetrightF,0);
    table.insert(targetrightF,0);
    local target = {};
    table.insert(target,0);
    table.insert(target,0);
    target[1] = (leftF[1]+rightF[1])/2.0;
    target[2] = (leftF[2]+rightF[2])/2.0;
    
    targetrightF[1] = target[1] + (rightF[1] - target[1]) * normalScale ;
    targetrightF[2] = target[2] + (rightF[2] - target[2]) * normalScale ;
    local rightFplus = self:faceStretch(rightF, rightF, targetrightF, curRadius, 1.0);
    rightF[1] = rightF[1] + rightFplus[1];
    rightF[2] = rightF[2] + rightFplus[2];
    
    targetleftF[1] = target[1] + (leftF[1] - target[1]) * normalScale ;
    targetleftF[2] = target[2] + (leftF[2] - target[2]) * normalScale ;
    local leftFplus = self:faceStretch(leftF, leftF, targetleftF, curRadius, 1.0);
    leftF[1] = leftF[1] + leftFplus[1];
    leftF[2] = leftF[2] + leftFplus[2];
end
--鼻子长短
function faceliftMicroShaping:_UpdateFaceKeypoints6(leftF,targetNose, curRadius)
   if leftF == nil  then
      LOG("currentPoint is nil(type6) !");
    end
   
    local targetleftF = {};
    table.insert(targetleftF,0);
    table.insert(targetleftF,0);
  
    targetleftF[1] = leftF[1] + targetNose[1] ;
    targetleftF[2] = leftF[2] + targetNose[2] ;
    local leftFplus = self:faceStretch(leftF, leftF, targetleftF, curRadius, 1.0);
    leftF[1] = leftF[1] + leftFplus[1];
    leftF[2] = leftF[2] + leftFplus[2];
end
--鼻子长短
function faceliftMicroShaping:_UpdateFaceKeypoints7(pt,target, normalScale,curRadius)
   if pt == nil  then
      LOG("currentPoint is nil(type7) !");
    end
   
    local targetF = {};
    table.insert(targetF,0);
    table.insert(targetF,0);
  
    targetF[1] = target[1] + (pt[1] - target[1])* normalScale;
    targetF[2] = target[2] + (pt[2] - target[2])* normalScale;
    local Fplus = self:faceStretch(pt, pt, targetF, curRadius, 1.0);
    pt[1] = pt[1] + Fplus[1];
    pt[2] = pt[2] + Fplus[2];
end

--眼睛角度
function faceliftMicroShaping:_UpdateFaceKeypoints8(pt,eye,delta, normalScale,curRadius)
    if pt == nil  then
      LOG("currentPoint is nil(type8) !");
    end
    local targetF = {};
    table.insert(targetF,0);
    table.insert(targetF,0);
  
    targetF[1] = (pt[1] - eye[1])*math.cos(delta ) - (pt[2] - eye[2])*math.sin(delta ) + eye[1]  ;
    targetF[2] = (pt[1] - eye[1])*math.sin(delta ) + (pt[2] - eye[2])*math.cos(delta ) + eye[2]  ;
    
    local Fplus = self:faceStretch(pt, pt, targetF, curRadius, 1.0);
    pt[1] = pt[1] + Fplus[1];
    pt[2] = pt[2] + Fplus[2];
end
--眼距
function faceliftMicroShaping:_UpdateFaceKeypoints9(pt,dis,curRadius)
    if pt == nil  then
      LOG("currentPoint is nil(type9) !");
    end
    local targetF = {};
    table.insert(targetF,0);
    table.insert(targetF,0);
    targetF[1] = pt[1] + dis[1] ;
    targetF[2] = pt[2] + dis[2] ;
    local Fplus = self:faceStretch(pt, pt, targetF, curRadius, 1.0);
    pt[1] = pt[1] + Fplus[1];
    pt[2] = pt[2] + Fplus[2];
end
function faceliftMicroShaping:_UpdateFaceKeypoints10(pt,mouthCenter,curRadius,normalScale)
    if pt == nil  then
      LOG("currentPoint is nil(type10) !");
    end
    local targetF = {};
    table.insert(targetF,0);
    table.insert(targetF,0);
    targetF[1] = mouthCenter[1] + (pt[1] - mouthCenter[1]) * normalScale ;
    targetF[2] = mouthCenter[2] + (pt[2] - mouthCenter[2]) * normalScale ;
    local Fplus = self:faceStretch(pt, pt, targetF, curRadius, 1.0);
    pt[1] = pt[1] + Fplus[1];
    pt[2] = pt[2] + Fplus[2];
end

function faceliftMicroShaping:_UpdateFaceKeypoints11(pt,target,curRadius)
     if pt == nil  then
      LOG("currentPoint is nil(type11) !");
    end
    local targetF = {};
    table.insert(targetF,0);
    table.insert(targetF,0);
    targetF[1] = pt[1] + target[1] ;
    targetF[2] = pt[2] + target[2] ;
    local Fplus = self:faceStretch(pt, pt, targetF, curRadius, 1.0);
    pt[1] = pt[1] + Fplus[1];
    pt[2] = pt[2] + Fplus[2];
end

function faceliftMicroShaping:NewframeCallback()
  if self.newframecallback ~= nil then
    return self.newframecallback
  end
  self.newframecallback = function()
    local lefteyes  = mathfunction.vector2array();
    local righteyes = mathfunction.vector2array();
    
    local facecoef = mathfunction.vector2();
    local eyeLarge = mathfunction.vector2();
    local facenarrow = mathfunction.vector2();
    local narrownoseCoef = 0.0;
    local lengnoseCoef = 0.0;
    local diseye = 0.0;
    local mouth = 0.0;
    local nosehump = 0.0;
    local lengphiltrum = 0.0;
    local opencanthus = mathfunction.vector2();
    local anglecanthus = mathfunction.vector2();

    local leftPointArray  = mathfunction.vector2array();
    local rightPointArray = mathfunction.vector2array();
    local nose  = mathfunction.vector2array();
    local mouse = mathfunction.vector2array();
    local chin  = mathfunction.vector2array();
    local foreheadPointArray = mathfunction.vector2array();
     
    local facesBox = mathfunction.vector4array();    local faces = videodecet:GetFaces();
    
    local maxFaceNum = 3;
    local faceNum = math.min(maxFaceNum, #faces);
    
    self.post:UNIFORM_FACESNUM(mathfunction.vector1(faceNum));

    for k=1, faceNum, 1 do
      local faceinfo = faces[k];
      self.keypoints = faceinfo:GetKeypointArray();
      --商汤从0开始，Lua从1开始，index需+1
      --keypointNum = #keypoints;
      --修正侧脸问题
      self.rotate = faceinfo:GetRotation();  --rotate p r y
      self.rate = (1.0 - math.abs(self.rotate[3]/40));
      self.nosehumpRate =  self.rotate[3];
      
      LOG("self.nosehumpRate-------------------------------------              " .. tostring(self.nosehumpRate));
      if(self.rate < 0) then
        self.rate = 0.0;  --侧脸角度超过60度?(40?)不瘦脸
      end
      
     --左眼
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[53]));  --1  52
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[54]));  --2  53
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[73]));  --3  72
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[55]));  --4  54
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[56]));  --5  55
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[57]));  --6  56
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[74]));  --7  73
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[58]));  --8  57
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[75]));  --9  74
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[105]));  --10 104
      lefteyes:PushBack(self:arrayToVec2(self.keypoints[66]));  --11 67
      
       --右眼 
      righteyes:PushBack(self:arrayToVec2(self.keypoints[62]));  --1  61
      righteyes:PushBack(self:arrayToVec2(self.keypoints[61]));  --2  60
      righteyes:PushBack(self:arrayToVec2(self.keypoints[76]));  --3  75
      righteyes:PushBack(self:arrayToVec2(self.keypoints[60]));  --4  59
      righteyes:PushBack(self:arrayToVec2(self.keypoints[59]));  --5  58
      righteyes:PushBack(self:arrayToVec2(self.keypoints[64]));  --6  63
      righteyes:PushBack(self:arrayToVec2(self.keypoints[77]));  --7  76
      righteyes:PushBack(self:arrayToVec2(self.keypoints[63]));  --8  62
      righteyes:PushBack(self:arrayToVec2(self.keypoints[78]));  --9  77
      righteyes:PushBack(self:arrayToVec2(self.keypoints[106]));  --10 105
      righteyes:PushBack(self:arrayToVec2(self.keypoints[70]));  --11 68
      
      --嘴
      for i = 85,103,1 do
          mouse:PushBack(self:arrayToVec2(self.keypoints[i]));
      end
      
      --左右眼大眼系数
      eyeLarge = mathfunction.vector2(self.coefTable[self.tableTF.TF_EYE], self.coefTable[self.tableTF.TF_EYE] );
      facecoef = mathfunction.vector2(self.coefTable[self.tableTF.TF_FACE],self.coefTable[self.tableTF.TF_FACE]);
      facenarrow = mathfunction.vector2(self.coefTable[self.tableTF.TF_NARROWFACE],self.coefTable[self.tableTF.TF_NARROWFACE]);
  
      chinleng = self.coefTable[self.tableTF.TF_LENGCHIN];
      narrownoseCoef = self.coefTable[self.tableTF.TF_THINNOSE];
      lengnoseCoef = self.coefTable[self.tableTF.TF_LENGNOSE];
      diseye = self.coefTable[self.tableTF.TF_EYEDIS];
      macintosh = self.coefTable[self.tableTF.TF_MACINTOSH];
      mouth = self.coefTable[self.tableTF.TF_MOUTH];
      hairline = self.coefTable[self.tableTF.TF_HAIRLINE];
      nosehump = self.coefTable[self.tableTF.TF_HUMPNOSE];
      lengphiltrum = self.coefTable[self.tableTF.TF_LENGPHILTRUM];
      
      opencanthus = mathfunction.vector2(self.coefTable[self.tableTF.TF_OPENCANTHUS],self.coefTable[self.tableTF.TF_OPENCANTHUS]);
      anglecanthus = mathfunction.vector2(self.coefTable[self.tableTF.TF_ANGLECANTHUS],self.coefTable[self.tableTF.TF_ANGLECANTHUS]);          
                                            
      for i = 1,16,1 do
        leftPointArray:PushBack(self:arrayToVec2(self.keypoints[i]));
      end

      --右脸
      for i = 33,18,-1 do
        rightPointArray:PushBack(self:arrayToVec2(self.keypoints[i]));
      end

      --鼻子  取点排列顺序：鼻子中间从上到下(鼻尖46)，左侧从上到下，右侧从上到下，共13个点：43,44,45,46,49,80,82,47,48,81,83,51,50
      --self.ns = self.keypoints[44]; --旧算法使用  
      
      nose:PushBack(self:arrayToVec2(self.keypoints[44]));  --1  43
      nose:PushBack(self:arrayToVec2(self.keypoints[45]));  --2  44
      nose:PushBack(self:arrayToVec2(self.keypoints[46]));  --3  45
      nose:PushBack(self:arrayToVec2(self.keypoints[47]));  --4  46
      nose:PushBack(self:arrayToVec2(self.keypoints[50]));  --5  49
      nose:PushBack(self:arrayToVec2(self.keypoints[81]));  --6  80
      nose:PushBack(self:arrayToVec2(self.keypoints[83]));  --7  82
      nose:PushBack(self:arrayToVec2(self.keypoints[48]));  --8  47
      nose:PushBack(self:arrayToVec2(self.keypoints[49]));  --9  48
      nose:PushBack(self:arrayToVec2(self.keypoints[82]));  --10 81
      nose:PushBack(self:arrayToVec2(self.keypoints[84]));  --11 83
      nose:PushBack(self:arrayToVec2(self.keypoints[52]));  --12 51
      nose:PushBack(self:arrayToVec2(self.keypoints[51]));  --13 50
      
      --下巴
      chin:PushBack(self:arrayToVec2(self.keypoints[17]));
      
      
        
    
        --根据0点和32点，补5个点，形成额头的点
        local p0 = self.keypoints[1];
        local p6 = self.keypoints[33];
        local p = {};
        table.insert(p,(p0[1]+p6[1])*0.5);
        table.insert(p,(p0[2]+p6[2])*0.5);

       foreheadPointArray:PushBack(self:arrayToVec2(p));
       local angle = 3.1415926/6.0;
       for i = 1,5,1 do
           local p1 = {};
           table.insert(p1,0);
           table.insert(p1,0);
           p1[1] = (p0[1] - p[1])*math.cos(-angle*i) - (p0[2] - p[2])*math.sin(-angle*i) + p[1];
           p1[2] = ((p0[1] - p[1])*math.sin(-angle*i) + (p0[2] - p[2])*math.cos(-angle*i) + p[2])/self.aspect_ratio;
       
           foreheadPointArray:PushBack(self:arrayToVec2(p1));
       end
        
        
       
        --local p1 = mathfunction.vector2();
        --foreheadPointArray
      
      --脸部包围盒
      local box = self:GetBoundingBox(self.keypoints, 0.25);
      facesBox:PushBack(box);      
      self.flag = 0;
      self:_getWarpedKeyPoints();
      faceinfo:UpdateKeypoints(self.keypoints);  
      
      --绘制debug关键点
      self.pointrender:SetShow(true);
      self.pointrender:Update(self.keypoints);

    end
    if faceNum > 0 then
        self.post:UNIFORM_LEFT_EYES(lefteyes);
        self.post:UNIFORM_RIGHT_EYES(righteyes);
        
        self.post:UNIFORM_MOUSE(mouse);
        
        self.post:UNIFORM_FACECOEF(facecoef*self.rate); 
        self.post:UNIFORM_EYE_LARGE(eyeLarge); 
        self.post:UNIFORM_FACE_NARROW(facenarrow*self.rate);
        
        self.post:UNIFORM_CHIN_LENG(mathfunction.vector1(chinleng)); 
        self.post:UNIFORM_NOSE_NARROW(mathfunction.vector1(narrownoseCoef)); 
        self.post:UNIFORM_NOSE_LENG(mathfunction.vector1(lengnoseCoef));         
        self.post:UNIFORM_CANTHUS_OPEN(opencanthus); 
        self.post:UNIFORM_CANTHUS_ANGLE(anglecanthus); 
        self.post:UNIFORM_EYE_DIS(mathfunction.vector1(diseye)); 
        
        self.post:UNIFORM_MACINTOSH(mathfunction.vector1(macintosh)); 
        self.post:UNIFORM_MOUTH(mathfunction.vector1(mouth)); 
        self.post:UNIFORM_LINE_HAIR(mathfunction.vector1(hairline)); 
        self.post:UNIFORM_NOSE_HUMP(mathfunction.vector1(nosehump)); 
        self.post:UNIFORM_NOSE_HUMP_RATE(mathfunction.vector1(self.nosehumpRate)); 
        self.post:UNIFORM_PHILTRUM_LENG(mathfunction.vector1(lengphiltrum)); 

        self.post:UNIFORM_LEFT_PTS(leftPointArray);
        self.post:UNIFORM_RIGHT_PTS(rightPointArray);
        self.post:UNIFORM_NOSE(nose);
        self.post:UNIFORM_CHIN(chin);
        self.post:UNIFORM_FOREHEAD(foreheadPointArray);
        

        self.post:UNIFORM_FACES_BOX(facesBox);

    end
  end
  
  return self.newframecallback;
end

function faceliftMicroShaping:GetNewframeCallback()
    return self.newframecallback
end

function faceliftMicroShaping:_getWarpedKeyPoints()
  --更新脸周关键点（鼻子眼睛嘴巴？）
  --[[local targetleftF = {};
  table.insert(targetleftF,0);
  table.insert(targetleftF,0);
  ]]
  --local facePoints = {}; 
  if self.coefTable[self.tableTF.TF_FACE] > 0.001 then
    for i = 1,33,1 do
      --local pt = {};
      --table.insert(pt,0);
      --table.insert(pt,0);
      --pt[1] = self.keypoints[i][1];
      --pt[2] = self.keypoints[i][2];
      local pt = self.keypoints[i]; 

      pt,self.flag = self:_UpdateFaceKeypoints1(pt,self.coefTable[self.tableTF.TF_FACE]);  
      --table.insert(facePoints,pt);
    end
   -- for i = 1,33,1 do
   --   self.keypoints[i] = facePoints[i];
   -- end
    
    --鼻子眼睛嘴巴（是否需要计算）
    for i = 82,104,1 do
      local pt = self.keypoints[i];
      pt,self.flag = self:_UpdateFaceKeypoints1(pt,self.coefTable[self.tableTF.TF_FACE]);  
      --self.keypoints[i] = pt;
    end
     for i = 44,52,1 do
      local pt = self.keypoints[i];
      pt,self.flag = self:_UpdateFaceKeypoints1(pt,self.coefTable[self.tableTF.TF_FACE]);  
      --self.keypoints[i] = pt;
    end
  end
  
  --更新眼周关键点位置
  --眼眶中心可不更新
  if self.coefTable[self.tableTF.TF_EYE] > 0.001 then
    for i=53,78,1 do
      if i <= 64 or i >= 73 then
        local pt = self.keypoints[i]; 
        --LOG("pt11111111111111----------------------x"..pt[1].."           y"..pt[2]);
        local eyeRadius = self:GetDistance( self.keypoints[85], self.keypoints[91])*0.33;
        --LOG("eyeRadius----------------------"..eyeRadius);
        pt,self.flag = self:_UpdateFaceKeypoints2(pt, self.keypoints[105],eyeRadius, self.coefTable[self.tableTF.TF_EYE]);      
        pt,self.flag = self:_UpdateFaceKeypoints2(pt, self.keypoints[106],eyeRadius, self.coefTable[self.tableTF.TF_EYE]);
        self.keypoints[i] = pt;
        --LOG("pt22222222222222----------------------x"..pt[1].."           y"..pt[2]);

      end
    end
  end
  --窄脸
  if self.coefTable[self.tableTF.TF_NARROWFACE] > 0.001 then
     for i = 3,13,1 do
      local pt = self.keypoints[i];
      pt,self.flag = self:_UpdateFaceKeypoints3(pt,self.coefTable[self.tableTF.TF_NARROWFACE],i);  
      
     end
     for i = 21,31,1 do
      local pt = self.keypoints[i];
      pt,self.flag = self:_UpdateFaceKeypoints3(pt,self.coefTable[self.tableTF.TF_NARROWFACE],i);  
      
     end
  end
  --下巴长短  
    if self.coefTable[self.tableTF.TF_LENGCHIN] > 0.001 or self.coefTable[self.tableTF.TF_LENGCHIN] < -0.001 then
      local curChin = {};
      table.insert(curChin,0);
      table.insert(curChin,0);
      curChin[1] = self.keypoints[17][1];   
      curChin[2] = self.keypoints[17][2]; 
      
      local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
      local normalScale = 1.0 + self.coefTable[self.tableTF.TF_LENGCHIN]*0.025;--  +或者-为拉长或者变短
      local curRadius = face_width*0.2;

      local targetchin = {};
      table.insert(targetchin,0);
      table.insert(targetchin,0);
      targetchin[1] = self.keypoints[94][1] + (curChin[1] - self.keypoints[94][1]) *  normalScale;   
      targetchin[2] = self.keypoints[94][2] + (curChin[2] - self.keypoints[94][2]) *  normalScale; 
      
      local k = 0.25;
      for i = 13,16,1 do
        local pt = self.keypoints[i];
        pt,self.flag = self:_UpdateFaceKeypoints4(pt,self.coefTable[self.tableTF.TF_LENGCHIN],i,k,curChin,targetchin,normalScale,face_width);
        k = k + 0.25;
      end
      k = 0.25;
      for i = 18,21,1 do
        local pt = self.keypoints[i];
        pt,self.flag = self:_UpdateFaceKeypoints4(pt,self.coefTable[self.tableTF.TF_LENGCHIN],i,k,curChin,targetchin,normalScale,face_width);  
        k = k + 0.25;
      end
      local ptchain = self.keypoints[17];
      local newchain = self:faceStretch(ptchain, curChin, targetchin, curRadius, 1.0);
      ptchain[1] = ptchain[1] + newchain[1];
      ptchain[2] = ptchain[2] + newchain[2];
    end  
     --瘦鼻
    if self.coefTable[self.tableTF.TF_THINNOSE] > 0.001 then
        local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
        local normalScale = 1.0 - self.coefTable[self.tableTF.TF_THINNOSE]*0.1;
        local curRadius = face_width*0.2;
        local pt1 = self.keypoints[81];
        local pt2 = self.keypoints[82];
        self:_UpdateFaceKeypoints5(pt1,pt2,curRadius,normalScale);  
        local pt3 = self.keypoints[83];
        local pt4 = self.keypoints[84];
        self:_UpdateFaceKeypoints5(pt3,pt4,curRadius,normalScale);    
        local pt5 = self.keypoints[48];
        local pt6 = self.keypoints[52];
        self:_UpdateFaceKeypoints5(pt5,pt6,curRadius,normalScale);    
    end
      --鼻子长短
      if self.coefTable[self.tableTF.TF_LENGNOSE] > 0.01 or self.coefTable[self.tableTF.TF_LENGNOSE] < -0.01 then
        local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
        local normalScale = self.coefTable[self.tableTF.TF_LENGNOSE]*0.01;-- +或者-为拉长或者变短
        local curRadius = face_width*0.2;
        
          local curChin = {};
          table.insert(curChin,0);
          table.insert(curChin,0);
          curChin[1] = self.keypoints[17][1];   
          curChin[2] = self.keypoints[17][2]; 
          
          local curNose = {};
          table.insert(curNose,0);
          table.insert(curNose,0);
          curNose[1] = self.keypoints[47][1];   
          curNose[2] = self.keypoints[47][2];   
          
          local targetNose = {};
          table.insert(targetNose,0);
          table.insert(targetNose,0);
          targetNose[1] = (curChin[1] - curNose[1]) *  normalScale ;
          targetNose[2] = (curChin[2] - curNose[2]) *  normalScale ;
          
          for i = 44,52,1 do
            local pt = self.keypoints[i];
            self:_UpdateFaceKeypoints6(pt,targetNose, curRadius);    
          end
          for i = 81,84,1 do
            local pt = self.keypoints[i];
            self:_UpdateFaceKeypoints6(pt,targetNose, curRadius);    
          end
    end
    --开眼角
    if self.coefTable[self.tableTF.TF_OPENCANTHUS] > 0.001 then
       local normalScale = 1.0 - self.coefTable[self.tableTF.TF_OPENCANTHUS]*0.03;
       local target = self.keypoints[44];
       local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
       local curRadius = face_width*0.2;
       local ptL = self.keypoints[56];
       self:_UpdateFaceKeypoints7(ptL,target, normalScale,curRadius);    
       local ptR = self.keypoints[59];
       self:_UpdateFaceKeypoints7(ptR,target, normalScale,curRadius);    
    end
    --眼睛角度
     if self.coefTable[self.tableTF.TF_ANGLECANTHUS] > 0.01 or  self.coefTable[self.tableTF.TF_ANGLECANTHUS] < -0.01 then
        local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
        local curRadius = face_width*0.1;
        local normalScale = 0.99;   
        local Leye = self.keypoints[105];
        local Reye = self.keypoints[106];
        
        local LeyePoint = {53,54,73,55,56,57,74,58};
        for i = 1, #LeyePoint do
            local ptL = self.keypoints[LeyePoint[i]];
            self:_UpdateFaceKeypoints8(ptL,Leye,self.coefTable[self.tableTF.TF_ANGLECANTHUS], normalScale,curRadius);   
        end
        local ReyePoint = {62,61,76,60,59,64,77,63};
        for i = 1, #ReyePoint do
            local ptR = self.keypoints[ReyePoint[i]];
            self:_UpdateFaceKeypoints8(ptR,Reye,-self.coefTable[self.tableTF.TF_ANGLECANTHUS], normalScale,curRadius);   
        end
    end
    --眼距
      if self.coefTable[self.tableTF.TF_EYEDIS] >= 0.01 or self.coefTable[self.tableTF.TF_EYEDIS] <= -0.01 then
          local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
          local curRadius = face_width*0.2;
          local normalScale = self.coefTable[self.tableTF.TF_EYEDIS]*0.01;-- +或者-为拉长或者变短
          local leftEye = self.keypoints[105];
          local rightEye = self.keypoints[106];
          local eyeCenter = {};
          table.insert(eyeCenter,0);
          table.insert(eyeCenter,0);
          eyeCenter[1] = (leftEye[1]+rightEye[1])*0.5;
          eyeCenter[2] = (leftEye[2]+rightEye[2])*0.5;
          local targetEyeL = {};
          table.insert(targetEyeL,0);
          table.insert(targetEyeL,0);
          targetEyeL[1] = leftEye[1]  +(eyeCenter[1] - leftEye[1]) *  normalScale;
          targetEyeL[2] = leftEye[2]  +(eyeCenter[2] - leftEye[2]) *  normalScale;
          local targetEyeR = {};
          table.insert(targetEyeR,0);
          table.insert(targetEyeR,0);
          targetEyeR[1] = rightEye[1]  +(eyeCenter[1] - rightEye[1]) *  normalScale;
          targetEyeR[2] = rightEye[2]  +(eyeCenter[2] - rightEye[2]) *  normalScale;
          local leftdis = {};
          table.insert(leftdis,0);
          table.insert(leftdis,0);
          leftdis[1] = targetEyeL[1] - leftEye[1];
          leftdis[2] = targetEyeL[2] - leftEye[2];
          local rightdis = {};
          table.insert(rightdis,0);
          table.insert(rightdis,0);
          rightdis[1] = targetEyeR[1] - rightEye[1];
          rightdis[2] = targetEyeR[2] - rightEye[2];
          
          local LeyePoint = {53,54,73,55,56,57,74,58,75,105};
          for i = 1, #LeyePoint do
            local ptL = self.keypoints[LeyePoint[i]];
            self:_UpdateFaceKeypoints9(ptL,leftdis,curRadius);   
          end
          
          local ReyePoint = {62,61,76,60,59,64,77,63,78,106};
          for i = 1, #ReyePoint do
            local ptR = self.keypoints[ReyePoint[i]];
            self:_UpdateFaceKeypoints9(ptR,rightdis,curRadius);   
          end
      end
      --嘴型
      if self.coefTable[self.tableTF.TF_MOUTH] >= 0.01 or self.coefTable[self.tableTF.TF_MOUTH] <= -0.01 then
          local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
          local curRadius = face_width*0.2;
          local normalScale = 1.0 - self.coefTable[self.tableTF.TF_MOUTH]*0.1;
          local mouthCenter = {};
          table.insert(mouthCenter,0);
          table.insert(mouthCenter,0);
          mouthCenter[1] = ( self.keypoints[99][1] +  self.keypoints[103][1]  )*0.5 ;   
          mouthCenter[2] = ( self.keypoints[99][2] +  self.keypoints[103][2]  )*0.5 ;   
          
          for i = 85,96,1 do
            local pt = self.keypoints[i];
            self:_UpdateFaceKeypoints10(pt,mouthCenter,curRadius,normalScale);   
          end
      end
      --人中长短
      if(self.coefTable[self.tableTF.TF_LENGPHILTRUM] or self.coefTable[self.tableTF.TF_LENGPHILTRUM] <= -0.01) then
          local face_width = self:GetDistance(self.keypoints[105],self.keypoints[106]);
          local curRadius = face_width*0.2;
          local normalScale = self.coefTable[self.tableTF.TF_LENGPHILTRUM]*0.01; --  +或者-为拉长或者变短
          local mouthUp =  self.keypoints[88];
          local noseBottom  = self.keypoints[50];
          local target = {};
          table.insert(target,0);
          table.insert(target,0);
          target[1] = (noseBottom[1] - mouthUp[1]) *  normalScale ;  
          target[2] = (noseBottom[2] - mouthUp[2]) *  normalScale ;   
          for i = 85,96,1 do
            local pt = self.keypoints[i];
            self:_UpdateFaceKeypoints11(pt,target,curRadius);   
          end
      end
end

function faceliftMicroShaping:faceStretch(textureCoord,originPosition, targetPosition, radius, curve)
    --LOG("curposition000000000000000000000000000000000000000000000000-----x"..textureCoord[1].."         y"..textureCoord[2]);
    --LOG("originPosition111111111111111111111111111111111111111111111-----x"..originPosition[1].."         y"..originPosition[2]);
    --LOG("targetPositionF22222222222222222222222222222222222222222222-----x"..targetPosition[1].."         y"..targetPosition[2]);
    --LOG("radius------------------------------------------------ "..radius);
    local direction = {};
    table.insert(direction,targetPosition[1] - originPosition[1]);
    table.insert(direction,targetPosition[2] - originPosition[2]);
    --LOG("direction111111111111111111111111111111111111111111111-----x"..direction[1].."         y"..direction[2]);
    local point = {};
    table.insert(point,0);
    table.insert(point,0);
    local lengthA = self:GetDistance(direction, point);
    --LOG("lengthA------------------------------------------------ "..lengthA);
    local lengthB = math.min(lengthA, radius);
    --LOG("lengthB------------------------------------------------ "..lengthB);
    direction[1] = direction[1]*(lengthB / lengthA);
    direction[2] = direction[2]*(lengthB / lengthA);
    --LOG("direction22222222222222222222222222222222222222222222-----x"..direction[1].."         y"..direction[2]);
    local infect = self:GetDistance(textureCoord, originPosition)/radius;
   -- LOG("infect------------------------------------------------ "..infect);
    if (1.0-infect) < 0.0 then
      infect = 0.0;
    elseif (1.0-infect) >1.0 then
      infect = 1.0;
    else
      infect = 1.0-infect;
    end
    infect =  math.pow(infect, curve);
    --LOG("infect------------------------------------------------ "..infect);
    direction[1] = direction[1] *infect;
    direction[2] = direction[2] *infect;
    --LOG("direction3333333333333333333333333333333333333333333-----x"..direction[1].."         y"..direction[2]);

    return direction ;
end

function faceliftMicroShaping:setWarpLevel(thinType,coef)  
  
  if thinType == self.tableTF.TF_FACE then
    coef = coef/100.0;
  elseif thinType == self.tableTF.TF_EYE  then
    coef = coef/300.0;
  elseif thinType == self.tableTF.TF_NARROWFACE then
    coef = coef/100.0;
  elseif thinType == self.tableTF.TF_LENGCHIN then 
    coef = coef/50.0;
  elseif thinType == self.tableTF.TF_THINNOSE then
    coef = coef/100.0;
  elseif thinType == self.tableTF.TF_LENGNOSE then
    coef = coef/50.0;
  elseif thinType == self.tableTF.TF_OPENCANTHUS then
    coef = coef/100.0;
  elseif thinType == self.tableTF.TF_ANGLECANTHUS then
    coef = coef/8000.0;
  elseif thinType == self.tableTF.TF_EYEDIS then 
    coef = coef/100.0;
  elseif thinType == self.tableTF.TF_MOUTH then 
    coef = coef/-100.0;
  elseif thinType == self.tableTF.TF_HAIRLINE then 
    coef = coef/100.0;
  elseif thinType == self.tableTF.TF_HUMPNOSE then
    coef = coef/100.0;
  elseif thinType == self.tableTF.TF_LENGPHILTRUM then
    coef = coef/20.0;
  end
  self.coefTable[thinType] = coef;
end                                             
                                               
function faceliftMicroShaping:setEyeParam(coefeye)
  self.coefTable[self.tableTF.TF_EYE] = 1.0 + coefeye * 0.05 * 0.22;
end

function faceliftMicroShaping:setFaceParam(coefface)
  self.facecoef = math.sqrt(coefface * 0.05 * 0.2) * 0.48;
end

function faceliftMicroShaping:setChinParam(coefchin)
  self.chincoef = math.sqrt(coefchin * 0.05 * 0.2) * 0.48;
end


function faceliftMicroShaping:Disable()
  self.post:Disable();
 end
 
 function faceliftMicroShaping:Enable()
  self.post:Enable();
 end
 

return faceliftMicroShaping;
