local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local quadnode = require "apolloutility.apollonode.quadnode"
local venuscore = require "venuscore"
local stringspilt = require "stringsplit"
local SDFTextNode = rendernode:extend();


--scale和旋转不能在外面设置
function SDFTextNode:new(font_Path)
    SDFTextNode.super.new(self);
    self:SetCull(false);
    self:SetShow(true);
    self.color = mathfunction.vector4(0.0,0.0,0.0,1.0);
    self.outline_color = mathfunction.vector4(0.0,0.0,0.0,1.0);
    self.outline_strength = mathfunction.vector1(0);
    self.shadow_strength = 0;
    self.shadow_offset = mathfunction.vector2(0.0,0.0);
    self.shadow_color = mathfunction.vector4(0.0,0.0,0.0,0.0);

    self.OUTLINE_COLOR =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OUTLINE_COLOR");
    self.OUTLINE_STRENGTH =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OUTLINE_STRENGTH");
    self.SMOOTH_DELTA =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"SMOOTH_DELTA");
    self.SHADOW_COLOR =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SHADOW_COLOR");
    self.SHADOW_OFFSET =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SHADOW_OFFSET");

  --读取字形的uv信息

    self.sdftextentity = apolloengine.SDFTextSetEntity();
    self.sdftextentity:ReadUVInfo(font_Path);
end

function SDFTextNode:SetShadowParams(shadow_offset,shadow_color)
    self.shadow_strength = 1.0;
    self.shadow_offset = shadow_offset;
    self.shadow_color = shadow_color;
end

function SDFTextNode:SetOutlineParams(outline_strength,outline_color)
    self.outline_strength = outline_strength;
    self.outline_color = outline_color;
end

function SDFTextNode:SetTextColor(color)
    self.color = color;
end


function SDFTextNode:CreateResource(str)
    --todo:将string字符串逐个转换为ascii码，然后读取uv再画

    self.sdftextentity:InsertString(str);
    self.sdftextstring = self.sdftextentity:GetString();
    self.uvlist = self.sdftextstring:GetUVList();
    -- 生成顶点数据用于映射上面生成的图片
    self.vertexstream = apolloengine.VertexStream();
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
            apolloengine.VertexBufferEntity.DT_FLOAT,
            apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 2);
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
            apolloengine.VertexBufferEntity.DT_FLOAT,
            apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 2);
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0,
            apolloengine.VertexBufferEntity.DT_FLOAT,
            apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 4);

    --创建索引流
    self.indicesstream = apolloengine.IndicesStream();
    self.indicesstream:SetIndicesType(
            apolloengine.IndicesBufferEntity.IT_UINT16);


    -- 计算文字实际占用宽度
    local space = 0;
    local width = 0;
    for _, glyph in pairs(self.uvlist) do
        width = width + glyph.width + space;
    end

    local x = 0;
    local y = 0;
    local startWidth = x;

    local index = 0;
    for i, glyph in ipairs(self.uvlist) do
        local  xpos = x;
        local ypos = y;
        local w = glyph.width;
        local h = glyph.height;

        -- lefttop
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos, ypos + h));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.x, glyph.y));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, self.color);


        -- leftbottom
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos, ypos));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.x, glyph.y + h));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, self.color);


        -- righttop
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w, ypos + h));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.x + w, glyph.y));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, self.color);


        -- rightbottom
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w, ypos));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.x + w, glyph.y + h));
        self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, self.color);

        -- 顶点数据
        self.indicesstream:PushIndicesData(0 + 4 * index);
        self.indicesstream:PushIndicesData(1 + 4 * index);
        self.indicesstream:PushIndicesData(2 + 4 * index);
        self.indicesstream:PushIndicesData(2 + 4 * index);
        self.indicesstream:PushIndicesData(1 + 4 * index);
        self.indicesstream:PushIndicesData(3 + 4 * index);

        index = index + 1;

        --字间距和文字框的最大宽度，目前没有换行的功能，高度按照字体的大小来决定
        x = x + glyph.width;

    end

    self.lutPath = "docs:lutpics/normal.png";
    self.tex = apolloengine.TextureEntity();
    self.tex:PushMetadata(apolloengine.TextureFileMetadata(
            apolloengine.TextureEntity.TU_STATIC,
            apolloengine.TextureEntity.PF_AUTO,1, false,
            apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
            apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
            apolloengine.TextureEntity.TF_LINEAR,
            apolloengine.TextureEntity.TF_LINEAR,
            self.lutPath));
    self.tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    self.tex:CreateResource();

    self.materialPath = "comm:documents/material/sdffont.material";
    if self.shadow_strength ~= 0 then
        self.outlineMaterialEntity = self.render:MakeMaterialAttachment();
        self.outlineMaterialEntity:PushMetadata(
                apolloengine.PathMetadata(self.materialPath));
        self.outlineMaterialEntity:SetParameter(self.OUTLINE_STRENGTH,mathfunction.vector1(0));
        self.outlineMaterialEntity:SetParameter(self.OUTLINE_COLOR,self.outline_color);
        self.outlineMaterialEntity:SetParameter(self.SHADOW_OFFSET,self.shadow_offset);
        self.outlineMaterialEntity:SetParameter(self.SHADOW_COLOR,self.shadow_color);
    end
    self.lyricMaterialEntity = self.render:MakeMaterialAttachment();
    self.lyricMaterialEntity:PushMetadata(
            apolloengine.PathMetadata(self.materialPath));
    self.lyricMaterialEntity:SetParameter(self.OUTLINE_STRENGTH,self.outline_strength);
    self.lyricMaterialEntity:SetParameter(self.OUTLINE_COLOR,self.outline_color);
    self.lyricMaterialEntity:SetParameter(self.SHADOW_OFFSET,self.shadow_offset);
    self.lyricMaterialEntity:SetParameter(self.SHADOW_COLOR,mathfunction.vector4(0,0,0,0));

    self.render:PushMetadata(
            apolloengine.RenderObjectMeshMetadate(
                    apolloengine.RenderComponent.RM_TRIANGLES,
                    apolloengine.ReferenceVertexMetadata(
                            apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
                            self.vertexstream),
                    apolloengine.ReferenceIndicesMetadata(
                            apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
                            self.indicesstream)));
    self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.tex);


    self.render:CreateResource();

    self.scale = mathfunction.vector3(1, 1, 1);
    self:SetLocalScale(10.0);
end

function SDFTextNode:SetLocalScale(s)
    local ns = self.scale * s;
    SDFTextNode.super.SetLocalScale(self, ns);
end

function SDFTextNode:SetLayer(l)
    self.layermin = -9 * 10 ^ l;
    self.layermax = -10 * 10 ^ l;
    self.min = mathfunction.vector3(1, self.layermin, 1);
    self.max = mathfunction.vector3(1, self.layermax, 1);
    self.bindbox = mathfunction.Aabbox3d(self.min, self.max);
    self:SetBindBox(self.bindbox);
end

function SDFTextNode:SetLayerFix(pos, scale)
    if scale == nil then
        scale = 1;
    end
    local newmin = (self.layermin - pos:z()) * 1 / scale;
    local newmax = (self.layermax - pos:z()) * 1 / scale;
    -- lua_debug("SetLayerFix min:"..newmin.." max:"..newmax)
    self.min:Set(1, newmin, 1);
    self.max:Set(1, newmax, 1);
    self.bindbox:SetMin(self.min);
    self.bindbox:SetMax(self.max);
    self:SetBindBox(self.bindbox);
end

function SDFTextNode:GetSize()
    return self.scale;
end

function SDFTextNode:Clear()
    -- 释放资源
    if self.textentity ~= nil then
        self.textentity:ReleaseText(self.stringid, self.m_fontsize);
    end
end

return SDFTextNode;
