

//输出在世界空间下的顶点属性
//输出两个变换矩阵
#SHADER_DEFINE StandardSkinVShader
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,				HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_NORMAL,					HIGH,    VEC3,        "in_Normal" },
        { ATTRIBUTE_TANGENT,				HIGH,    VEC3,        "in_Tangent"},
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,        "in_Coordinate0"},

        { CAMERA_VIEWPROJ,					HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },

    }

    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,   HIGH,    VEC4,        "out_Position" },
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,        "out_Coordinate0"},
        { WORLDSPACE_NORMAL,      HIGH,   VEC4,         "out_NormalWS"},
        { WORLDSPACE_TANGENT,     HIGH,   VEC4,         "out_TangentWS"},
        { WORLDSPACE_BINORMAL,    HIGH,   VEC4,         "out_BinormalWS"},
    }

#SHADER_CODE
		vec4 out_Position = in_ViewPorj * in_Transfrom * in_Position;
		vec3 out_PositionWS  = vec3(in_Transfrom * in_Position);
    vec4 out_NormalWS;
    vec4 out_TangentWS;
    vec4 out_BinormalWS;

    out_NormalWS.xyz = (in_WorldRotation * in_Normal);
    out_NormalWS.xyz = normalize(out_NormalWS.xyz);

    out_TangentWS.xyz =  (in_WorldRotation * in_Tangent);
    out_TangentWS.xyz = normalize(out_TangentWS.xyz);

    out_BinormalWS.xyz = (cross(out_TangentWS.xyz, out_NormalWS.xyz));
    out_BinormalWS.xyz = normalize(out_BinormalWS.xyz);

    out_NormalWS.w = out_PositionWS.x;
    out_TangentWS.w = out_PositionWS.y;
    out_BinormalWS.w = out_PositionWS.z;
		
    vec2 out_Coordinate0;
    out_Coordinate0.xy = in_Coordinate0.xy;
    gl_Position = out_Position;

#END_CODE
#END_DEFINE

#SHADER_DEFINE StandardSkinPShader
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,        "in_Coordinate0"},
        { WORLDSPACE_NORMAL,      HIGH,   VEC4,         "in_NormalWS"},
        { WORLDSPACE_TANGENT,     HIGH,   VEC4,         "in_TangentWS"},
        { WORLDSPACE_BINORMAL,    HIGH,   VEC4,         "in_BinormalWS"},
        { CAMERA_WORLDPOSITION,	  HIGH,	  VEC3,			"in_CameraPosition"},

        { MAIN_TEXTURE,			  NONE,			TEXTURE2D,		"MainTex" },
        { NORMAL_TEXTURE,		  NONE,			TEXTURE2D,		"NormalTexture" },
        { SPECULAR_TEXTURE,		  NONE,			TEXTURE2D,		"SpecularTex" },
        { BRDF_TEXTURE,		      NONE,			TEXTURE2D,		"BRDFTex" },
        { SKY_BOX,          NONE,   TEXTURECUBE, "skybox"},

        { SHADE_COLOR,            HIGH,         VEC4,       "ShadeColor"},
        { SHADOW_COLOR,           HIGH,         VEC4,       "ShadowColor"},
        { SPECULAR_COLOR,         HIGH,         VEC4,       "SpecularColor"},
        { FRESNEL,                HIGH,         FLOAT,      "Fresnel"},
        { SHADOW_INTENSITY,       HIGH,         FLOAT,      "ShadowIntensity"},
        { EXTRA_SHADE_RANGE,      HIGH,         FLOAT,      "extraShadeRange"},
        { LIGHT1DIR,              HIGH,         VEC3,          "Light1Dir"},
        { LIGHT1COLOR,            HIGH,         VEC3,          "Light1Color"},
        { LIGHT1INTENSITY,        HIGH,         FLOAT,         "Light1Intensity"},
        { LIGHT2DIR,              HIGH,         VEC3,          "Light2Dir"},
        { LIGHT2COLOR,            HIGH,         VEC3,          "Light2Color"},
        { LIGHT2INTENSITY,        HIGH,         FLOAT,         "Light2Intensity"},
        { CUS_AMBIENT,            HIGH,         VEC4,          "CusAmbient"},
        { SURFACE_COLOR,				  HIGH,	        FLOAT,		"ShadowMask" },
        { AMBIENT_COLOR,		      HIGH,		      VEC3,		"shAmbient" },
    }

    FUNCTION_OUTPUT =
    {
    }
#SHADER_CODE
    
    vec3 worldPos = vec3(in_NormalWS.w, in_TangentWS.w, in_BinormalWS.w);
    vec3 viewDir_S = in_CameraPosition.xyz - worldPos.xyz;
    vec3 viewDir = normalize(viewDir_S);

    vec3 mainNormal = texture2D(NormalTexture, in_Coordinate0.xy).xyz;
    vec3 groundNormal = mainNormal.xyz * 2.0 - 1.0;

    // normal in world space
    vec3 worldNormal = groundNormal.x * in_TangentWS.xyz + groundNormal.y * in_BinormalWS.xyz
					+ groundNormal.z * in_NormalWS.xyz;
    worldNormal = normalize(worldNormal);

    // common
   // vec3 light1Dir = normalize(Light1Dir);
	//vec3 light2Dir = normalize(Light2Dir);
  vec3 light1Dir = (Light1Dir);
	vec3 light2Dir = (Light2Dir);
	vec3 h1 = normalize(viewDir + light1Dir);
	float nv = max(dot(worldNormal, viewDir), 0.0);
	float nh1 = max(dot(worldNormal, h1), 0.0);

  // main color
  vec3 mainColor = texture2D(MainTex, in_Coordinate0.xy).xyz;
	mainColor *= mainColor;

    vec3 specular = texture2D(SpecularTex, in_Coordinate0.xy).xyz;
	float roughness = 1.0 - specular.x;
	float curveness = specular.y;
	float shadowSelfMask = 1.0 - specular.z;

    // diffuse
  vec3 diffuse = vec3(0.0, 0.0, 0.0);
	float shaowRange = nv / extraShadeRange;
	float diffuseShadow = mix(1.0, nv, shadowSelfMask);
	float nl1 = dot(worldNormal, light1Dir);
	float nl1Warp = (nl1 * 0.5) + 0.5;

	vec2 brdfUV = vec2(nl1Warp, curveness);
	vec3 brdfColor = texture2D(BRDFTex, brdfUV).xyz;
  
	float shadow = ShadowMask;
	vec3 adjuseColor = mix(ShadowColor.xyz, brdfColor.xyz, shadow);
	vec3 fontLight = adjuseColor * Light1Color * Light1Intensity * mainColor;
	vec3 cc = brdfColor;

	float nl2 = (dot(worldNormal, light2Dir) + 0.5) * 0.7;
	nl2 = max(nl2, 0.0);
	nl2 = nl2 * nl2;
	nl2 = nl2 * nl2;
	nl2 = nl2 * nl2;

	vec3 backLight = nl2 * Light2Color * Light2Intensity * mainColor;
	backLight = backLight * mainNormal.z;
	backLight = backLight / (vec3(1.0, 1.0, 1.0) + backLight);

	//vec3 ambientLight =  CusAmbient.xyz * mainColor;
  vec3 ambientLight =  shAmbient.xyz * mainColor;
  vec3 white = vec3(1.0, 1.0, 1.0);
	vec3 diffuseShadowColor = mix(ShadeColor.xyz, white.xyz, diffuseShadow);
	vec3 outDiffuse = (fontLight + backLight + ambientLight) * diffuseShadowColor;

  //
  vec3 reflectDir = reflect(-viewDir, worldNormal);
  float perceptualRoughness = roughness; //(1.7 - 0.7 * roughness) * roughness;
  float mipmapLevel = perceptualRoughness * 4.0;
  #ifdef GL_EXT_shader_texture_lod
  vec4 iblColor = textureCubeLod(skybox, reflectDir, mipmapLevel);
  #else
  vec4 iblColor = textureCube(skybox, reflectDir);
  #endif
  iblColor.xyz = iblColor.xyz * iblColor.w * 4.0;
  
  float f0Inv = min(Fresnel * 2.0, 1.0) - Fresnel;
  float powNV = pow((1.0 - nv), 4.0);
  float SF = f0Inv * powNV + Fresnel;

  //vec3 envLight = iblColor.xyz * 0.5 * SF * CusAmbient.xyz;
  vec3 envLight = iblColor.xyz * 0.5 * SF * shAmbient.xyz;
  
  // D
  float modifyRoughness = max(roughness * roughness, 0.1);
  float NdotH = nh1;
  float a2 = modifyRoughness * modifyRoughness;
  float d = (NdotH * a2 - NdotH) * NdotH + 1.0f; // 2 mad
  d = 0.31830988618f * a2 / (d * d + 1e-7f);
  d = min(d, 100.0);

    // F
    float fLerp = 1.0 - nv;
	float fV = mix(Fresnel, 1.0, fLerp);
	vec3 outspecular = (d*fV * Light1Color * Light1Intensity + envLight) * SpecularColor.xyz;
  gl_FragColor = vec4(outspecular + outDiffuse, 1.0);
  
  //gl_FragColor = vec4(ShadowMask,ShadowMask,ShadowMask, 1.0);
  
#END_CODE
#END_DEFINE



