

#SHADER_DEFINE CutHorizontalConstIn

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
    float cut_horizontal_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalConstOut

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
    float cut_horizontal_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalLinearIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
    float cut_horizontal_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalLinearOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
    float cut_horizontal_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE


#SHADER_DEFINE CutHorizontalSineIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
    float cut_horizontal_out_EasingV = sin((in_Progress - 1.0) * 1.5707963267948966) + 1.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalSineOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
    float cut_horizontal_out_EasingV = sin(in_Progress * 1.5707963267948966);
#END_CODE
#END_DEFINE


#SHADER_DEFINE CutHorizontalExponentialIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	

  float cut_horizontal_out_EasingV = 0.0;
  if (in_Progress == 0.0)
    cut_horizontal_out_EasingV = in_Progress;
  else
    cut_horizontal_out_EasingV = pow(2.0,10.0 * (in_Progress - 1.0));
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalExponentialOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
  float cut_horizontal_out_EasingV = 0.0;
  if (in_Progress == 1.0)
    cut_horizontal_out_EasingV = in_Progress;
  else
    cut_horizontal_out_EasingV = 1.0 - pow(2.0, -10.0 * in_Progress);
#END_CODE
#END_DEFINE


#SHADER_DEFINE CutHorizontalBackIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
  float cut_horizontal_out_EasingV = pow(in_Progress,3.0) - in_Progress * sin(in_Progress * 3.141592653589793);
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalBackOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	
  float f_cutbackout = 1.0 - in_Progress;
  float cut_horizontal_out_EasingV = 1.0 - (pow(f_cutbackout, 3.0) - f_cutbackout * sin(f_cutbackout * 3.141592653589793));
#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalBounceOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}
#SHADER_CODE

  const float a_cutbout = 4.0 / 11.0;
  const float b_cutbout = 8.0 / 11.0;
  const float c_cutbout = 9.0 / 10.0;

  const float ca_cutbout = 4356.0 / 361.0;
  const float cb_cutbout = 35442.0 / 1805.0;
  const float cc_cutbout = 16061.0 / 1805.0;

  float t2_cutbout = in_Progress * in_Progress;
  
  float cut_horizontal_out_EasingV = 0.0;
  if (in_Progress < a_cutbout)
  {
    cut_horizontal_out_EasingV = 7.5625 * t2_cutbout;
  }
  else
  {
    if (in_Progress < b_cutbout)
    {
      cut_horizontal_out_EasingV = 9.075 * t2_cutbout - 9.9 * in_Progress + 3.4;
    }
    else
    {
      if (in_Progress < c_cutbout)
      {
        cut_horizontal_out_EasingV = ca_cutbout * t2_cutbout - cb_cutbout * in_Progress + cc_cutbout;
      }
      else
      {
        cut_horizontal_out_EasingV = 10.8 * in_Progress * in_Progress - 20.52 * in_Progress + 10.72;
      }
    }
  }

#END_CODE
#END_DEFINE

#SHADER_DEFINE CutHorizontalBounceIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { CUT_HORIZONTAL_EASING_VALUE,           MEDIUM, FLOAT,  "cut_horizontal_out_EasingV"},
	}

#SHADER_CODE	

  float t_cutbin = 1.0 - in_Progress;
  const float a_cutbin = 4.0 / 11.0;
  const float b_cutbin = 8.0 / 11.0;
  const float c_cutbin = 9.0 / 10.0;

  const float ca_cutbin = 4356.0 / 361.0;
  const float cb_cutbin = 35442.0 / 1805.0;
  const float cc_cutbin = 16061.0 / 1805.0;

  float t2_cutbin = t_cutbin * t_cutbin;
  
  float cut_horizontal_out_EasingV = 0.0;
  if (t_cutbin < a_cutbin)
  {
    cut_horizontal_out_EasingV = 7.5625 * t2_cutbin;
  }
  else
  {
    if (t_cutbin < b_cutbin)
    {
      cut_horizontal_out_EasingV = 9.075 * t2_cutbin - 9.9 * t_cutbin + 3.4;
    }
    else
    {
      if (t_cutbin < c_cutbin)
      {
        cut_horizontal_out_EasingV = ca_cutbin * t2_cutbin - cb_cutbin * t_cutbin + cc_cutbin;
      }
      else
      {
        cut_horizontal_out_EasingV = 10.8 * t_cutbin * t_cutbin - 20.52 * t_cutbin + 10.72;
      }
    }
  }
  cut_horizontal_out_EasingV = 1.0 - cut_horizontal_out_EasingV;

#END_CODE
#END_DEFINE



