

#SHADER_DEFINE YCrCbSpAFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_1,             NONE,      TEXTURE2D,   "in_Texture_Y" },
        { TEXTURE_2,             NONE,      TEXTURE2D,   "in_Texture_CrCb" },
        { TEXTURE_3,             NONE,      TEXTURE2D,   "in_Texture_A" },
        { COLOR_OFFSET,          MEDIUM,    VEC3,        "in_ColorOffset" },
        { COLOR_MATRIX,          MEDIUM,    MAT3,        "in_ColorMatrix" },
        { ATTRIBUTE_COORDNATE0,  MEDIUM,    VEC2,        "in_Coordinate" },
    }
    FUNCTION_OUTPUT =
    {

    }

#SHADER_CODE
    float  y = texture2D(in_Texture_Y,  in_Coordinate).r;
    vec2 crcb = texture2D(in_Texture_CrCb, in_Coordinate).rg;
    float cr = crcb.r;
    float cb = crcb.g;
    float  a = texture2D(in_Texture_A,  in_Coordinate).r;
    vec3 color = in_ColorMatrix * (vec3(y, cr, cb) + in_ColorOffset);
    gl_FragColor = vec4(color, a);
#END_CODE
#END_DEFINE
