#SHADER_DEFINE ShineMotionVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE ShineMotionFragment

	FUNCTION_INPUT = 
	{
        { ATTRIBUTE_COORDNATE0,		       HIGH,	 VEC2,		      	"texture_coord"},
        { CUR_FRAME_TEXTURE,	           NONE,	 TEXTURE2D,		  	"cur_frame_texture" },
        { PRE_FRAME_TEXTURE,	           NONE,	 TEXTURE2D,		  	"pre_frame_texture" },
	}

#SHADER_CODE
	vec3 cur_rgb = texture2D(cur_frame_texture, texture_coord).xyz + 0.5 / 255.0;
	vec3 pre_rgb = texture2D(pre_frame_texture, texture_coord).xyz + 0.5 / 255.0;

    vec3 coeff = vec3(0.299, 0.587, 0.114);

    float cur_bright = dot(coeff, cur_rgb);
    float pre_bright = dot(coeff, pre_rgb);

    float diff = abs(cur_bright - pre_bright) > 30.0/255.0 ? 1.0 : 0.0;
    float motion_v = diff * cur_bright * 0.7;

	gl_FragColor = vec4(motion_v, motion_v, motion_v, 1.0);
    
#END_CODE
#END_DEFINE



