#include "functions/util.function"
#SHADER_DEFINE OutLine2Vertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
       
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE OutLine2Fragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_uBwm,		    	NONE,	TEXTURE2D,	  "uBwm" },
		{ TEXTURE_uTua,		    	NONE,	TEXTURE2D,	  "uTua" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,	"vUV"},
		{ UNIFORM_uOs,				HIGH,	VEC2,	"uOs"},
        { UNIFORM_uHiu,            	MEDIUM, FLOAT,   "uHiu"},
        { UNIFORM_uJhi,             MEDIUM, FLOAT,   "uJhi"},
        { UNIFORM_uKj,            	MEDIUM, FLOAT,   "uKj"},
        { UNIFORM_uVer,            MEDIUM, FLOAT,   "uVer"}
	}
  
#SHADER_CODE

	highp vec2 sos;
    //if (abs(uVer - 2.0) < 0.0001) {
        sos = normalize(decode(texture2D(uBwm, vUV)));
    //}
    //else sos = texture2D(uBwm, vUV).xy;

    vec2 zz0 = sos;
    vec2 zz1 = -sos;
    vec2 uv0 = vUV;
    vec2 uv1 = vUV;

    float k = gauss(0.0, uHiu);
    float sum = k;
    vec2 result = texture2D(uTua, vUV).rg * k;

    for (int i = 1; i < 7; ++i) {
        uv0 += zz0 * uOs * sqrt(float(i));
        vec2 c = texture2D(uTua, uv0).rg;
        vec2 good;
        //if ( abs(uVer - 2.0) < 0.0001) 
		//{
            good = normalize(decode(texture2D(uBwm, uv0)));
        //}
        //else good = normalize(texture2D(uBwm, uv0).xy);

        zz0 = sign(dot(good, zz0)) * good;
        
        k = gauss(float(i), uHiu);
        sum += k;
        result += c * k;
    }

    for (int i = 1; i < 7; ++i) {
        uv1 += zz1 * uOs * sqrt(float(i));
        vec2 c = texture2D(uTua, uv1).rg;
        vec2 good;
       // if (abs(uVer - 2.0) < 0.0001) {
            good = normalize(decode(texture2D(uBwm, uv1)));
        //}
        //else good = normalize(texture2D(uBwm, uv1).xy);

        zz1 = sign(dot(good, zz1)) * good;
        
        k = gauss(float(i), uHiu);
        sum += k;
        result += c * k;
    }
    result /= sum;

    float dad = uJhi / 5.0;

 //   result.r = (result.r > 0.) ? 1.0 : 1.0 + rvr(10.0 * 1.0 * (result.r - 0.));
    result.g = (result.g > dad) ? 1.0 : 1.0 + rvr(10.0 * uKj * 3. * (result.g - dad));

    gl_FragColor = vec4(result.g);
    //gl_FragColor = texture2D(uTua, vUV);
#END_CODE

#END_DEFINE


