#SHADER_DEFINE LineVertex

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,      HIGH,    VEC4,    "vert_pos" },
        { ATTRIBUTE_COORDNATE0,    HIGH,    VEC2,    "vert_tex_coord"},
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,    HIGH,    VEC2,    "frag_tex_coord" },
    }

#SHADER_CODE
    gl_Position         = vert_pos;
    vec2 frag_tex_coord = vert_tex_coord;
#END_CODE
#END_DEFINE

#SHADER_DEFINE LineFragment

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,       HIGH,    VEC2,         "frag_tex_coord"},
        { UNIFORM_PRE_FRAME,          NONE,    TEXTURE2D,    "pre_frame_tex" },
        { UNIFORM_CUR_FRAME,          NONE,    TEXTURE2D,    "cur_frame_tex" },
        { UNIFORM_TEX_SIZE,           HIGH,    VEC2,         "tex_size"},
        { UNIFORM_IS_HORIZONTAL_LINE, HIGH,    FLOAT,        "is_horizontal_line", "1.0" },
    }

#SHADER_CODE

    vec2  offset   = 1.0 / tex_size;

    vec2 tex_coord = frag_tex_coord;
    if(int(is_horizontal_line) == 0)
    {
        float temp  = tex_coord.x;
        tex_coord.x = tex_coord.y;
        tex_coord.y = temp;
    }
    
    vec2 tex_coord_00 = tex_coord + vec2(-1.0 * offset.x, -1.0 * offset.y);
    vec2 tex_coord_01 = tex_coord + vec2( 0.0,            -1.0 * offset.y);
    vec2 tex_coord_02 = tex_coord + vec2( 1.0 * offset.x, -1.0 * offset.y);
    
    vec2 tex_coord_10 = tex_coord + vec2(-1.0 * offset.x, 0.0);
    vec2 tex_coord_11 = tex_coord + vec2( 0.0,            0.0);
    vec2 tex_coord_12 = tex_coord + vec2(1.0 * offset.x,  0.0);
    
    vec2 tex_coord_20 = tex_coord + vec2(-1.0 * offset.x, 1.0 * offset.y);
    vec2 tex_coord_21 = tex_coord + vec2( 0.0,            1.0 * offset.y);
    vec2 tex_coord_22 = tex_coord + vec2( 1.0 * offset.x, 1.0 * offset.y);

    vec3 pre_color_00 = texture2D(pre_frame_tex, tex_coord_00).rgb;
    vec3 pre_color_01 = texture2D(pre_frame_tex, tex_coord_01).rgb;
    vec3 pre_color_02 = texture2D(pre_frame_tex, tex_coord_02).rgb;

    vec3 pre_color_10 = texture2D(pre_frame_tex, tex_coord_10).rgb;
    vec3 pre_color_11 = texture2D(pre_frame_tex, tex_coord_11).rgb;
    vec3 pre_color_12 = texture2D(pre_frame_tex, tex_coord_12).rgb;

    vec3 pre_color_20 = texture2D(pre_frame_tex, tex_coord_20).rgb;
    vec3 pre_color_21 = texture2D(pre_frame_tex, tex_coord_21).rgb;
    vec3 pre_color_22 = texture2D(pre_frame_tex, tex_coord_22).rgb;

    vec3 coeff = vec3(0.299, 0.587, 0.114);

    float pre_y_00 = dot(coeff, pre_color_00);
    float pre_y_01 = dot(coeff, pre_color_01);
    float pre_y_02 = dot(coeff, pre_color_02);

    float pre_y_10 = dot(coeff, pre_color_10);
    float pre_y_11 = dot(coeff, pre_color_11);
    float pre_y_12 = dot(coeff, pre_color_12);

    float pre_y_20 = dot(coeff, pre_color_20);
    float pre_y_21 = dot(coeff, pre_color_21);
    float pre_y_22 = dot(coeff, pre_color_22);

    float pre_patch_total_y = pre_y_00 + pre_y_01 + pre_y_02 +
                              pre_y_01 + pre_y_11 + pre_y_12 +
                              pre_y_20 + pre_y_21 + pre_y_22;

    vec3 cur_color_00 = texture2D(cur_frame_tex, tex_coord_00).rgb;
    vec3 cur_color_01 = texture2D(cur_frame_tex, tex_coord_01).rgb;
    vec3 cur_color_02 = texture2D(cur_frame_tex, tex_coord_02).rgb;

    vec3 cur_color_10 = texture2D(cur_frame_tex, tex_coord_10).rgb;
    vec3 cur_color_11 = texture2D(cur_frame_tex, tex_coord_11).rgb;
    vec3 cur_color_12 = texture2D(cur_frame_tex, tex_coord_12).rgb;

    vec3 cur_color_20 = texture2D(cur_frame_tex, tex_coord_20).rgb;
    vec3 cur_color_21 = texture2D(cur_frame_tex, tex_coord_21).rgb;
    vec3 cur_color_22 = texture2D(cur_frame_tex, tex_coord_22).rgb;

    float cur_y_00 = dot(coeff, cur_color_00);
    float cur_y_01 = dot(coeff, cur_color_01);
    float cur_y_02 = dot(coeff, cur_color_02);

    float cur_y_10 = dot(coeff, cur_color_10);
    float cur_y_11 = dot(coeff, cur_color_11);
    float cur_y_12 = dot(coeff, cur_color_12);
    
    float cur_y_20 = dot(coeff, cur_color_20);
    float cur_y_21 = dot(coeff, cur_color_21);
    float cur_y_22 = dot(coeff, cur_color_22);

    //calculate y change

    float cur_patch_total_y = cur_y_00 + cur_y_01 + cur_y_02 +
                              cur_y_01 + cur_y_11 + cur_y_12 +
                              cur_y_20 + cur_y_21 + cur_y_22;

    float patch_y_ave_change     = (cur_patch_total_y - pre_patch_total_y) / 9.0;
    float abs_patch_y_ave_change = abs(patch_y_ave_change);

    //calculate gradient using scharr operator
    vec2 patch_grad = vec2( 0.1875 * (cur_y_02 - cur_y_00 + cur_y_22 - cur_y_20) + 0.625 * (cur_y_12 - cur_y_10),
                            0.1875 * (cur_y_20 - cur_y_00 + cur_y_22 - cur_y_02) + 0.625 * (cur_y_21 - cur_y_01) );


    //revert grad if patch become brighter 
    if(cur_patch_total_y > pre_patch_total_y)
        patch_grad *= -1.0;

    gl_FragColor = vec4(0.5 * patch_grad + 0.5, 
                        length(patch_grad), 
                        abs_patch_y_ave_change);

#END_CODE
#END_DEFINE

