
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
UNIFORM_CENTER = { "Center", VEC2, "0.0,0.0"},
UNIFORM_SPILT = { "Split", FLOAT, "1.0"},
UNIFORM_SATURATION = { "Saturation", FLOAT, "1.0"},
UNIFORM_LUMINANCE = { "Luminance", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "Halfcolor"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 UNIFORM_CENTER;
float UNIFORM_SPILT;
float UNIFORM_SATURATION;
float UNIFORM_LUMINANCE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}

float coloradjust(float k0,float k1,float k2, float k3,float x)
{
    float x2 = x * x;
    float x3 = x2 * x;
    return k0 * x3 + k1 * x2 + k2 * x + k3;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    const float3 w = float3(0.3, 0.59, 0.11);
	float2 textureCoordinate = i.uv;

    float3 rgb1 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,textureCoordinate).rgb;
    
    float2 coord1 = textureCoordinate - float2(0.5, 0.25) + UNIFORM_CENTER;
    float2 coord2 = textureCoordinate - float2(0.5, 0.75) + UNIFORM_CENTER;
    float3 rgb2 = (textureCoordinate.y < 0.5) ? (TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,coord1).rgb) : (TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,coord2).rgb);
    
    coord1 = textureCoordinate - float2(0.5, 0.167) + UNIFORM_CENTER;
    coord2 = textureCoordinate - float2(0.5, 0.835) + UNIFORM_CENTER;
    float3 rgb3;
    if(textureCoordinate.y < 0.33)
    {
        rgb3 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,coord1).rgb;
    }
    else if(textureCoordinate.y < 0.66)
    {
        rgb3 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,textureCoordinate).rgb;
    }
    else
    {
        rgb3 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,coord2).rgb;
    }
    
    float3 splitrgb = (UNIFORM_SPILT < 2.5)? rgb2 : rgb3;
    float3 rgb = (UNIFORM_SPILT < 1.5)? rgb1: splitrgb;
	float rgb_w_dot = dot(rgb,w);
    float3 grey = lerp(rgb,float3(rgb_w_dot,rgb_w_dot,rgb_w_dot),UNIFORM_SATURATION);
    grey = float3(coloradjust(-2.805,4.307,-0.501,0.0,grey.r),coloradjust(-2.805,4.307,-0.501,0.0,grey.g),coloradjust(-2.805,4.307,-0.501,0.0,grey.b)) * UNIFORM_LUMINANCE;
    rgb = float3(coloradjust(0.7261,-2.009,2.2838,0.0,rgb.r),coloradjust(0.7261,-2.009,2.2838,0.0,rgb.g),coloradjust(0.7261,-2.009,2.2838,0.0,rgb.b));
    rgb = (textureCoordinate.x < 0.5)? rgb : grey;
    mainColor = float4(rgb, 1.0);
}
ENDCG
#END
