// DO_NOT_PATCH_ME
precision mediump float;
varying highp vec2 textureCoord;

varying highp vec2 textureShift_1;
varying highp vec2 textureShift_2;
varying highp vec2 textureShift_3;
varying highp vec2 textureShift_4;

uniform sampler2D srcImageTex;
uniform sampler2D blurImageTex;

uniform lowp float smoothIntensity;
uniform lowp float sharpIntensity;

const lowp float theta = 0.1;

void main()
{
    lowp vec4 inColor = texture2D(srcImageTex, textureCoord);

    //firstly, smooth
    lowp vec3 smoothColor = inColor.rgb;
    if (smoothIntensity > 0.0) {
        lowp vec4 preColor = texture2D(blurImageTex, textureCoord);
        lowp vec3 meanColor = preColor.rgb;
        
        mediump float p = clamp((min(inColor.r, meanColor.r-0.1)-0.2)*4.0, 0.0, 1.0);
        mediump float kMin = (1.0 - preColor.a / (preColor.a + theta)) * p * smoothIntensity;
        
        smoothColor = mix(inColor.rgb, meanColor.rgb, kMin);
    }

    //secondly, sharpen
    vec3 epmColor = smoothColor;
    if (sharpIntensity > 0.0) {
        mediump float sum = texture2D(srcImageTex,textureShift_1).g;
        sum += texture2D(srcImageTex,textureShift_2).g;
        sum += texture2D(srcImageTex,textureShift_3).g;
        sum += texture2D(srcImageTex,textureShift_4).g;
        sum = sum * 0.25;
        
        float hPass = inColor.g - sum + 0.5;
        float flag = step(0.5, hPass);
        
        highp vec3 tmpColor = vec3(2.0 * hPass + smoothColor - 1.0);
        highp vec3 sharpColor = mix(max(vec3(0.0), tmpColor), min(vec3(1.0), tmpColor), flag);
        
        epmColor = mix(smoothColor.rgb, sharpColor, sharpIntensity);
    }

    gl_FragColor = vec4(epmColor, inColor.a);
}