(function() {
  var COMMANDS = {
    bold: 'bold',
    italic: 'italic',
    underline: 'underline',
    numbers: 'number',
    bullets: 'bullet',
    href: 'href'
  };
  var $note = document.getElementById('note');
  var editor = new Notes.Editor({ container: $note });
  // window.editor = editor;

  window.NOTE = {
    reset: function(content) {
      editor.reset();

      try {
        var data = JSON.parse(content);
        editor.setNoteData(data);
      } catch (_) {
      }
    },
    setPlaceholder: function(placeholder) {
      editor.placeholder = placeholder;
    },
    blurFocus: function() {
      editor.blur();
    },
    focus: function() {
      editor.focus();
    },
    toggle: function(cmdKey) {
      editor.toggleSelectionStyle(COMMANDS[cmdKey]);
      updateState();
    },
    hrefRange: [],
    getHref: function() {
      editor.autoFitLinkSelectedRange();
      NOTE.hrefRange = editor.getSelectedRange();
      window.location.href = 'note-href://' + encodeURIComponent(editor.getSingleWholeLink() || '');
    },
    setHref: function(href) {
      editor.setLink(href, NOTE.hrefRange);
      updateState();
    }
  };

  $note.addEventListener('selectionchange', e => {
    updateState();
  });
  $note.addEventListener('change', updateContent);
  $note.addEventListener('link-activated', e => {
    window.open(e.detail.href, '_target');
  });

  var clickedY = 0;
  $note.addEventListener('click', function(e) {
    updateState();
    clickedY = e.y;
  });

  window.onresize = function() {
    var windowHeight = document.firstElementChild.offsetHeight;
    if (clickedY > windowHeight) {
      scrollTo(0, clickedY);
    }
  };

  function updateContent() {
    var content = editor.getNoteData();
    var ret = content ? JSON.stringify(content) : '';
    window.location.href = 'note-content://' + encodeURIComponent(ret);
  }

  function updateState() {
    var keys = Object.keys(COMMANDS);
    var activeCommands = keys
        .filter(isCommandActive)
        .join(',');
    setTimeout(function() {
      window.location.href = 'note-state://' + encodeURIComponent(activeCommands);
    }, 0);
  }

  function isCommandActive(key) {
    return editor.getSelectionStyles().includes(COMMANDS[key]);
  }
})();
