local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "window.editor.command.content_manager"
local GetConditionsCommand = CommandBase:extend("GetConditionsCommand");

function GetConditionsCommand:new(uuid, smsId, transId)
    GetConditionsCommand.super.new(self);
    self._uuid = uuid;
    self._smsId = smsId;
    self._transId = transId;
    self._Conditions = nil;
end

function GetConditionsCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        local tran = ani:GetTransitionById(self._smsId, self._transId);
        if tran then
           self._Conditions = tran.Conditions;
        end
      end
    end
    self:EndCmd();
end

function GetConditionsCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return GetConditionsCommand;