
local venusjson = require "venusjson"
local venuscore = require "venuscore"
local object = require "classic"
local torch = require "torch"

local Operator = require "torchutility.operator"

local Vec3Length = Operator:extend();


function Vec3Length:new(lastpos, currentpos)
    Vec3Length.super.new(self,currentpos);
    self.lastpos = lastpos;
    self.vcount = self.lastpos:size()[1] * self.lastpos:size()[2];--位置变量的个数
    self.rcount = self.lastpos:size()[1];
end

function Vec3Length:Caculate( currentpos )
    local diff = torch.csub(currentpos,self.lastpos);
    local ret = torch.cmul(diff,diff);
    local lengthtensor = torch.Tensor(currentpos:size()[1]);
    for i = 1,currentpos:size()[1] do
        lengthtensor[i] = ret[i][1]+ret[i][2]+ret[i][3];
    end
    return lengthtensor;
end

function Vec3Length:Derivative(param)
    if self:HasParamForD(1,param) then
      local J = torch.zeros(self.rcount, self.vcount);
      for i=1, self.rcount do
        J[{i, i*3-2}] = 2*self.paramcache[1]:R()[{i,1}] - 2*self.lastpos[{i,1}];
        J[{i, i*3-1}] = 2*self.paramcache[1]:R()[{i,2}] - 2*self.lastpos[{i,2}];
        J[{i, i*3}]   = 2*self.paramcache[1]:R()[{i,3}] - 2*self.lastpos[{i,3}];
      end
      return J;
    end
end

return Vec3Length;