local torch = require "torch"
local Object = require "classic"


local AutoTensor = Object:extend();

function AutoTensor:new(...)
  self:V(...);
end

function AutoTensor:V(...)
  self.changed = true;
  self.resultcache = torch.Tensor(...)
end

function AutoTensor:VFromTorch(value)
  self.changed = true;
  self.resultcache = value:clone():contiguous();
end

function AutoTensor:R()
  self.changed = false;
  return self.resultcache;
end

function AutoTensor:D2()
  return 1;
end

function AutoTensor:HaveParam(r,...)
  local param = {...};
  if #param ~=1 then
    return false;
  end
  param = param[1];
  if self == param then
    return true;
  else
    return false;
  end
end

function AutoTensor:IsChanged()
  if self.changed then
    return true;
  end
  return false;
end

function AutoTensor:__tostring()
  self:R();
  return self.resultcache:__tostring();
end

return AutoTensor;