local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local rgb2gray = {}
rgb2gray.renderobject = nil;
rgb2gray.material = nil;
rgb2gray.Queue = 102;


function rgb2gray:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"COUNT");
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/rgb2gray.material" );
  self.material:SetParameter(self.COUNT, mathfunction.vector1(math.pi/12.0));
  --self:_SetParam(size);
  return self.Queue;
end

function rgb2gray:Resizeview(size)
  --self:_SetParam(size);
end

function rgb2gray:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return rgb2gray;