local BN = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local AE = require "apolloengine"
local ED = require "bluecore.eventdispatcher"
local Types = require "venuscore.rtti.types"

local ScreenRotation = BN:extend();

function ScreenRotation:new(...)
  ScreenRotation.super.new(self, ...)
  self.rotation = 90
end

function ScreenRotation:_OnUpdate(eventParam)
  local output = eventParam
  ERROR("output = "..tostring(output));
  if output == nil then
    self.nextExecIdx = 0 -- break exec
  elseif output ~= self.rotation then
    if output == 0 then
      self.nextExecIdx = 1
    elseif output == 90 then
      self.nextExecIdx = 2
    elseif output == 180 then
      self.nextExecIdx = 3
    elseif output == 270 then
      self.nextExecIdx = 4
    else
      ERROR("error direction "..tostring(output));
      self.nextExecIdx = 0
      output = 90 -- force
    end
    self.rotation = output
  else
    self.nextExecIdx = 0 -- if equal, do not exec next
  end
  ERROR("self.rotation = "..tostring(self.rotation)..","..tostring( self.nextExecIdx));
  return  self.rotation
end

function ScreenRotation:_OnNextBranch()
  return self.nextExecIdx
end

function ScreenRotation:RegisterTriggerFunc(func, bluePrintSelf)
  ED:RegisterCallback(
          BD.Event.ScreenRotationChangePath, -- target object(global)
          BD.Event.ScreenRotationEvent.SCREEN_ROTATION_CHANGE, -- event
          func,
          bluePrintSelf
  );
  AE.IActionSystem:AddClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_ACCELEROMETER, -- rotation needs accelerometer
          bluePrintSelf.Node:GetComponent(AE.Node.CT_BLUEPRINT),
          AE.SensorsTrackingComponent.VENUS_FREQ_UI);             -- ui freq is ok
end

function ScreenRotation:_OnStop()
  -- ED:RegisterCallback -- Do not Need
  AE.IActionSystem:RemoveClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_ACCELEROMETER,
          self.graph.Node:GetComponent(AE.Node.CT_BLUEPRINT));

end

ScreenRotation:RegisterOutput(1, Types.FloatType, "rotation", "degree", 90);
ScreenRotation:RegisterExecOutput(1, "0",   "exec"); -- 顺时针
ScreenRotation:RegisterExecOutput(2, "90",  "exec"); -- 手机竖屏的方向
ScreenRotation:RegisterExecOutput(3, "180", "exec");
ScreenRotation:RegisterExecOutput(4, "270", "exec");


ScreenRotation:SetFunctionName("ScreenRotation");
ScreenRotation:SetFunctionType(BD.EVENT_FUNCTION_NODE);
ScreenRotation:SetEventType(BD.EventType.RegisterCallback);

return ScreenRotation;
