local Types = require "venuscore.rtti.types"
local vc = require "libvenuscore"

local BlueNode = require "bluecore.bluenode"

local SoundPlayer  = require "soundplayer"
-- 贴纸音效的诞生
local SpawnAudio = BlueNode:extend();

local A_CREATE = 1
local A_CREATE_PLAY = 2
local A_PLAY = 3
local A_PAUSE = 4
local A_RESUME = 5
local A_STOP = 6

---- 游戏运行模式
function SpawnAudio:new(...)
  SpawnAudio.super.new(self, ...)
end

---- 重写BLueNode:Update
function SpawnAudio:Update(execIdx)

  -- Step.0 处理参数依赖的Update
  if execIdx == nil and self.nextExecNum ~= 0 then  return end

  -- Step.1 先执行输入的依赖节点update 并获取参数
  self:_GetInput();

  -- Step.2 Debug控制 -- TODO(hhl) 迁移到基类
  if _KRATOSEDITOR then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end

  -- Step.3 执行本方法
  self.outputResults = {}
  local musicPath = self.inputArgs[1]
  local repeatTime = self.inputArgs[2];
  self:_RunIt(execIdx, musicPath, repeatTime);

  -- Step.4 execute next only when execute in 'create&play'
  return execIdx == A_CREATE_PLAY and 1 or 0
end

function SpawnAudio:_GetRealPath(path)
  local suffix = string.sub(path, #path-2)
  local support = Types.AudioPathType:GetFileType();
  for _, type in ipairs(support) do
    if type ==  suffix then
      local musicPath = path --= vc.IFileSystem:PathAssembly(path) ;
      ERROR("musicPath "..tostring(musicPath)..","..tostring(path))
      return musicPath
    end
  end
  ERROR("path is not valid:"..tostring(path))
  return nil
end


function SpawnAudio:_RunIt(execIdx, musicPath, repeatTime)
  if execIdx == A_CREATE then
    local realPath =  self:_GetRealPath(musicPath);
    if  realPath~= nil then
      if self.player ~= nil then
        self.player:StopSound();
      end
      self.player = SoundPlayer();
      self.player:LoadSound(realPath);
    end
  elseif execIdx == A_CREATE_PLAY then
    local realPath =  self:_GetRealPath(musicPath);
    if  realPath~= nil then
      if self.player ~= nil then
        self.player:StopSound();
      end
      self.player = SoundPlayer();
      self.player:LoadSound(realPath);
      self.player:PlaySound(repeatTime);
    end
  elseif execIdx == A_PLAY then
    if self.player then
      self.player:PlaySound(repeatTime);
    else
      ERROR("SpawnAudio, nil, A_PLAY")
    end
  elseif execIdx == A_PAUSE then
    if self.player then
      self.player:PauseSound();
    else
      ERROR("SpawnAudio, nil, A_PAUSE")
    end
  elseif execIdx ==A_RESUME then
    if self.player then
      self.player:ResumeSound();
    else
      ERROR("SpawnAudio, nil, A_RESUME")
    end
  elseif execIdx == A_STOP then
    if self.player then
      self.player:StopSound();
    else
      ERROR("SpawnAudio, nil, A_STOP")
    end
  else
    ERROR("SpawnAudio, out of index");
  end
end


-- 停止时候关闭所有的音效,释放对象
function SpawnAudio:_OnStop()
  if self.player ~= nil then
    self.player:StopSound();
  end
  self.player = nil
end

-- 重置场景 停止播放音乐
function SpawnAudio:_OnReset()
  if self.player ~= nil then
    self.player:StopSound();
  end
end

SpawnAudio:RegisterInput(1, Types.AudioPathType, "path", "audio path", "");
SpawnAudio:RegisterInput(2, Types.IntType, "repeat", "repeat times until stop, 0:loop forever", 0)

SpawnAudio:RegisterExecInput(A_CREATE, "create", "create");
SpawnAudio:RegisterExecInput(A_CREATE_PLAY, "create&play", "create,then play");
SpawnAudio:RegisterExecInput(A_PLAY, "play", "play");
SpawnAudio:RegisterExecInput(A_PAUSE, "pause", "pause");
SpawnAudio:RegisterExecInput(A_RESUME, "resume", "resume");
SpawnAudio:RegisterExecInput(A_STOP, "stop", "stop");

SpawnAudio:RegisterExecOutput(1, "then", "exec");

SpawnAudio:SetFunctionName("SpawnAudio");


return SpawnAudio;
