


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mf = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local GetWorldScaleVec3 = BlueNode:extend();

---- 游戏运行模式
function GetWorldScaleVec3:new(...)
  GetWorldScaleVec3.super.new(self, ...)
end

function GetWorldScaleVec3:_OnUpdate(args)
  return args[1]:GetWorldScale();
end



---- 编辑器模式

GetWorldScaleVec3:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetWorldScaleVec3:RegisterOutput(1, mf.vector3:RTTI(), "scale", "世界缩放");


GetWorldScaleVec3:SetFunctionName("GetWorldScale");


return GetWorldScaleVec3 ;

