local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetScriptValue = require "bluecore.base.set_script_value"
local SetScriptVector1 = SetScriptValue:extend();


---- vector1和number都放这里
function SetScriptVector1:new(...)
  SetScriptVector1.super.new(self, ...)

end

function SetScriptVector1:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];
  local newVal = args[3];
  local originVal = scriptIns[para];
  newVal = type(originVal) == "userdata" and newVal or newVal.mx;
  scriptIns:SetScriptValue(para, newVal);
end



function SetScriptVector1:_IsRightType(key, value, scriptIns)
  local isVec1 = type(value) == "userdata" and value:RTTI() == mathfunction.vector1:RTTI();
  local isNum = type(value) == "number";
  return isVec1 or isNum;
end



SetScriptVector1:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
SetScriptVector1:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING);
SetScriptVector1:RegisterInput(3, mathfunction.vector1:RTTI(), "ParaValue", "参数值", mathfunction.vector1(1.0));


SetScriptVector1:RegisterExecInput(1, "exec", "执行");

SetScriptVector1:RegisterExecOutput(1, "exec", "执行");

SetScriptVector1:SetFunctionName("SetScriptVector1");


return SetScriptVector1 ;

