local Types = require "venuscore.rtti.types"
local cv = require "computervisionfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local HasResult = BlueNode:extend();

---- 游戏运行模式
function HasResult:new(...)
  HasResult.super.new(self, ...)
end

function HasResult:_OnUpdate(args)
  local comp = args[1];
  return comp ~= nil and comp:HasResult()
end

---- 编辑器模式
HasResult:RegisterInput(1, cv.RecognitionComponent:RTTI(), "target", "RecognitionComponent组件", BlueSelf());
HasResult:RegisterOutput(1, Types.BoolType, "hasResult", "是否有结果?");
HasResult:SetFunctionName("Has Result?");
HasResult:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return HasResult;

