local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectVector3 = SetPostEffectValue:extend();


---- 游戏运行模式
function SetPostEffectVector3:new(...)
  SetPostEffectVector3.super.new(self, ...)
end

function SetPostEffectVector3:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector3:RTTI();
end



SetPostEffectVector3:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectVector3:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); --instance可选的vector3变量
SetPostEffectVector3:RegisterInput(3, mathfunction.vector3:RTTI(), "ParaValue", "参数值", mathfunction.vector3(1.0,1.0,1.0));


SetPostEffectVector3:RegisterExecInput(1, "exec", "执行");

SetPostEffectVector3:RegisterExecOutput(1, "exec", "执行");

SetPostEffectVector3:SetFunctionName("SetPostEffectVector3");


return SetPostEffectVector3 ;

