local cv = require "computervisionfunction"
local DeviceResource = require "apolloengine.deviceresource"

local _nativeUpdate = cv.GPUSegmentComponent.Update;

local resourceNameMap =
{
  [cv.GPUSegmentComponent.cvGPU_Mask_FullFace] = DeviceResource.DEVICE_FACEPARSE_FULL_FACE,
  [cv.GPUSegmentComponent.cvGPU_Mask_Left_Eye] = DeviceResource.DEVICE_FACEPARSE_LEFT_EYE,
  [cv.GPUSegmentComponent.cvGPU_Mask_Right_Eye] = DeviceResource.DEVICE_FACEPARSE_RIGHT_EYE,
  [cv.GPUSegmentComponent.cvGPU_Mask_Mouth] = DeviceResource.DEVICE_FACEPARSE_LIP,
  [cv.GPUSegmentComponent.cvGPU_Mask_Left_Brow] = DeviceResource.DEVICE_FACEPARSE_LEFT_BROW,
  [cv.GPUSegmentComponent.cvGPU_Mask_Right_Brow] = DeviceResource.DEVICE_FACEPARSE_RIGHT_BROW,
  [cv.GPUSegmentComponent.cvGPU_Mask_Nose] = DeviceResource.DEVICE_FACEPARSE_NOSE,
  [cv.GPUSegmentComponent.cvGPU_Mask_Head] = DeviceResource.DEVICE_FACEPARSE_FORHEAD,
}

local Update = function (self, dt)
  local tex = self:GetMask()
  local type = self.Type
  local faceID = self.FaceID
  local resourceName = resourceNameMap[type]
  if tex ~= nil and resourceName ~= nil then
    DeviceResource:PushDeviceResource(resourceName .. tostring(faceID), tex)
  end
  --WARNING(string.format("SUNTYLOG: GPUSegComp.Update %s %s %s", tostring(self:isStarted()), tostring(self:GetMask()), tostring(self.Type)))
  _nativeUpdate(self, dt)
end

rawset(cv.GPUSegmentComponent, "Update", Update)