#SHADER_DEFINE RadialblurVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCoordinate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE RadialblurFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0, HIGH,    VEC2,          "texcoord"},
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
		{ UNIFORM_BLUR_SCALE,	MEDIUM,	    FLOAT,		"blurscale"},
		{ UNIFORM_BLUR_CENTER,	HIGH,	    VEC2,		"center"}    
	}

#SHADER_CODE

    vec2 pos = center - texcoord;
    vec3 rgb = texture2D(uniCurrentTexture,texcoord).rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 2.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 3.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 4.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 5.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 6.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 7.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 8.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 9.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 10.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 11.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 12.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 13.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 14.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 15.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 16.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 17.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 18.0).rgb + rgb;
    rgb = texture2D(uniCurrentTexture,texcoord + blurscale * pos* 19.0).rgb + rgb;
    rgb = rgb / 20.0;
    gl_FragColor = vec4(rgb,1.0);


#END_CODE
#END_DEFINE
