
#SHADER_DEFINE PixelCutVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    vec2 out_TexCooridate = in_TexCooridate.xy;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE


#SHADER_DEFINE PixelCutFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    	{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"tex" },
    	{ X_CUT_SIZE,		HIGH,	FLOAT,		"x_cut_size" },
        { Y_CUT_SIZE,       HIGH,   FLOAT,      "y_cut_size" },
	}
  
 
  
#SHADER_CODE

    gl_FragColor = texture2D(tex,vec2(textureCoordinate.x*x_cut_size,textureCoordinate.y*y_cut_size)); 
    //gl_FragColor = vec4(1.0); 

#END_CODE
#END_DEFINE
