#include "functions/mlaa.function"

#SHADER_DEFINE NeighborBlendVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_pos" },
	}

#SHADER_CODE
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_pos = in_Position.xy;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE






#SHADER_DEFINE  NeighborBlendFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"texture" },
    { TEXTURE_NEIGHBOR_BLEND,		NONE,	TEXTURE2D,		"textureblend" },
   
     { PIXEL_SIZE,		HIGH,	VEC2,		"in_pixelSize"},
	}
  
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}
  
#SHADER_CODE



    vec2 texcoord = textureCoordinate;
    vec4 topLeft = texture2D(textureblend,texcoord).rgba;
    vec4 out_SurfaceColor = vec4(0.0,0.0,0.0,0.0);
    vec2 PIXEL_SIZE = vec2(1.0/544.0,1.0/960.0);
    PIXEL_SIZE = in_pixelSize;  
    float yInverse = -1.0;
    float bottom = texture2D(textureblend,texcoord+vec2(0.0,1.0*yInverse)*PIXEL_SIZE).g;
    float  right= texture2D(textureblend,texcoord+vec2(1.0,0.0)*PIXEL_SIZE).a;
    vec4 a = vec4(topLeft.r, right, topLeft.b, bottom);
    float sum = dot(a, vec4(1.0,1.0,1.0,1.0));
    if (sum > 0.0) 
    {
    
      vec4 o = a * vec4(PIXEL_SIZE.y,PIXEL_SIZE.y,PIXEL_SIZE.x,PIXEL_SIZE.x);
      vec4 color = vec4(0.0,0.0,0.0,0.0);
      color = mad((texture2D(texture,texcoord + vec2( 0.0, -o.r*yInverse))), pow(vec4(a.r,a.r,a.r,a.r),vec4(1.0)), color);
      color = mad((texture2D(texture,texcoord + vec2( 0.0, o.g*yInverse))), pow(vec4(a.g,a.g,a.g,a.g),vec4(1.0)), color);
      color = mad((texture2D(texture,texcoord + vec2( -o.b, 0.0))), pow(vec4(a.b,a.b,a.b,a.b),vec4(1.0)), color);
      color = mad((texture2D(texture,texcoord + vec2( o.a, 0.0))), pow(vec4(a.a,a.a,a.a,a.a),vec4(1.0)), color);
      out_SurfaceColor = color / sum;
      out_SurfaceColor.a = 1.0;
      out_SurfaceColor = encodegamma(out_SurfaceColor);
    } else 
    {
        out_SurfaceColor =  encodegamma(vec4(texture2D(texture,textureCoordinate).rgb,1.0));     
    }
#END_CODE
#END_DEFINE