//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////

#SHADER_DEFINE EmitterStretch

	FUNCTION_INPUT = 
	{
    { CAMERA_PROJECTION,		HIGH,	MAT4,		"in_Porjection" },
		{ CAMERA_VIEW,				HIGH,	MAT4,		"in_View" },
    { ATTRIBUTE_EMITTER_LIFE,	HIGH,	FLOAT,	"in_Life" },
		{ EMITTER_AGE,				    HIGH,	FLOAT,	"in_Age" },
    { PARTICLE_SPEED,     MEDIUM, VEC3, "in_Speed"},
    { PARTICLE_STRETCH_RATIO_ONE,   MEDIUM, FLOAT, "in_StretchRatio1"},
    { PARTICLE_STRETCH_RATIO_TWO,   MEDIUM, FLOAT, "in_StretchRatio2"},
    { PARTICLE_STRETCH_RATIO_THREE,   MEDIUM, FLOAT, "in_StretchRatio3"},
    { PARTICLE_STRETCH_RATIO_FOUR,   MEDIUM, FLOAT, "in_StretchRatio4"},
	}

	FUNCTION_OUTPUT = 
	{
    { PARTICLE_STRETCH,       MEDIUM, MAT3, "out_Stretch" },
	}

#SHADER_CODE

  float in_ControlStretch1 = in_StretchRatio1;
  float in_ControlStretch2 = in_StretchRatio2;
  float in_ControlStretch3 = in_StretchRatio3;
  float in_ControlStretch4 = in_StretchRatio4;
  
  float srt = in_Age / in_Life;
  float srt2 = srt * srt;
  float one_minus_srt = 1.0 - srt;
  float one_minus_srt2 = one_minus_srt * one_minus_srt;
  float stretchratio = in_ControlStretch1 * one_minus_srt2 * one_minus_srt + in_ControlStretch2 * 3.0 * srt * one_minus_srt2 + in_ControlStretch3 * 3.0 * srt2 * one_minus_srt + in_ControlStretch4 * srt2 * srt;
  vec3 speedNormlized = normalize(in_Speed.xyz);
  
  //旋转矩阵                
  mat3 out_Stretch = mat3(speedNormlized.x,-speedNormlized.y,0.0,
                        speedNormlized.y,speedNormlized.x,0.0,
                        stretchratio,0.0,1.0);  //将缩放也存进mat3
  
#END_CODE
#END_DEFINE
