#include "functions/rgb_hsv.function"

#SHADER_DEFINE BrightnessMapVertex

    FUNCTION_INPUT = 
	{
    	{ ATTRIBUTE_POSITION, 		  HIGH,	  VEC4,	     "in_Position" },
    	{ ATTRIBUTE_COORDNATE0,     HIGH,   VEC2,  "in_TexCooridate" },
	} 
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,       "out_TexCooridate" },
	}

#SHADER_CODE
 
    gl_Position = in_Position;
    vec2 out_TexCooridate =  in_TexCooridate ;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  BrightnessMapFragment

    FUNCTION_INPUT = 
    {
      	{ TEXTURE_DIFFUSE,            NONE,    TEXTURE2D,  	"inputImageTexture" },
      	{ ATTRIBUTE_COORDNATE0,       HIGH,    VEC2,         "in_TexCoordinate" },
    }

#SHADER_CODE
    vec3 rgbcolor = texture2D(inputImageTexture, in_TexCoordinate).rgb;
    vec3 hsvcolor = rgb2hsv(rgbcolor);
    gl_FragColor = vec4(vec3(hsvcolor.z), 1.0);
#END_CODE
#END_DEFINE