
#DEFPARAMS
PIXEL_SIZE		= {"PixelSize", VEC2, "1.0,1.0" },
OPACITY 		= {"Opacity", FLOATRANGE, "1, 1, 0" },
_LutMap 		= {"Lut Map", TEXTURE2D, "white" },
COLOR_RANGEA	= {"CustomColor", VEC3, "1.0, 1.0, 1.0"},
COLOR_RANGEB 	= {"CustomColor", VEC3, "1.0, 1.0, 1.0"},
MASK_VALID      = {"MASK_VALID", FLOAT, "0.0"},
MaskTex         = {"MaskTex", TEXTURE2D, "white"},

[Keywords(
	COLOR_ORIGINAL,
    COLOR_BLEND,
    COLOR_CUSTOM 
)]
_ColorMode = {"ColorMode", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
[Keywords(
	BLEND_NORMAL, 
	BLEND_MULTIPLY, 
	BLEND_SCREEN, 
	BLEND_HUE, 
	BLEND_SATURATION,
	BLEND_LUMINOSITY, 
	BLEND_COLOR, 
	BLEND_BLEND,
	BLEND_EXCLUSION,
	BLEND_HARDLIGHT,
	BLEND_VIVIDLIGHT,
	BLEND_OVERLAY,
	BLEND_COLORBURN,
	BLEND_COLORDODGE,
	BLEND_SOFTLIGHT,
	BLEND_HARDMIX,
	BLEND_PINLIGHT,
	BLEND_LINEARLIGHT,
	BLEND_DIFF,
	BLEND_LINEARBURN,
	BLEND_SUB,
	BLEND_LUT,
	BLEND_ADD
)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName  = "glare_blend_normal"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = {ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE}
DRAW_MODE    = {CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS}
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile COLOR_ORIGINAL COLOR_BLEND COLOR_CUSTOM
#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY BLEND_SCREEN BLEND_HUE BLEND_SATURATION BLEND_LUMINOSITY BLEND_COLOR BLEND_BLEND BLEND_EXCLUSION BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_OVERLAY BLEND_COLORBURN BLEND_COLORDODGE BLEND_SOFTLIGHT BLEND_HARDMIX BLEND_PINLIGHT BLEND_LINEARLIGHT BLEND_DIFF BLEND_LINEARBURN BLEND_SUB BLEND_LUT BLEND_ADD
#include "common.inc"
#include "blendfunc_plenty.inc"
struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
    float2 rtuv : TEXCOORD1;
    float2 random : TEXCOORD2;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 rtuv : TEXCOORD1;
	float2 random : TEXCOORD2;
    float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_GLOSSINESS;
Texture2D _LutMap;
Texture2D MaskTex;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_GLOSSINESS_Sampler;
SamplerState _LutSampler;
SamplerState MashSampler;
float3 COLOR_RANGEA;
float3 COLOR_RANGEB;
float2 PIXEL_SIZE;
float OPACITY;
float MASK_VALID;


v2f vert(appdata v)
{
    v2f o;
    o.vertex	             = UniformNDC(float4(v.vertex.x, v.vertex.y, 0.0, 1.0));
    o.uv                     = float2(v.uv.x, 1-v.uv.y);
    o.rtuv.xy                = float2(v.rtuv.x, 1-v.rtuv.y);
	o.rtuv.zw 				 = float2(v.vertex.z,-v.vertex.w) / 2 + 0.5; 
	o.random				 = v.random;
    return o;
}


void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float MaskAlpha = MASK_VALID > 0.0 ? MaskTex.Sample(MashSampler, i.rtuv.zw).a : 1.0;

 if(MASK_VALID > 0.0 && MaskAlpha < 1.0)
 {
	 mainColor = float4(0.0,0.0,0.0,0.0);
 }
 else
 {

    float4 MColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
	float alpha = MColor.a * OPACITY;
    
	float4 RColor = TEXTURE_GLOSSINESS.Sample(TEXTURE_GLOSSINESS_Sampler, i.rtuv.xy);
	float3 dstColor = RColor.rgb;

#if COLOR_ORIGINAL
    float3 srcColor = MColor.rgb;
#elif  COLOR_BLEND
    float3 Middle =  TEXTURE_GLOSSINESS.Sample(TEXTURE_GLOSSINESS_Sampler, i.rtuv.zw).rgb;
	float3 left =  TEXTURE_GLOSSINESS.Sample(TEXTURE_GLOSSINESS_Sampler, i.rtuv.zw + float2(-PIXEL_SIZE.x, 0)).rgb;
	float3 right =  TEXTURE_GLOSSINESS.Sample(TEXTURE_GLOSSINESS_Sampler, i.rtuv.zw + float2(PIXEL_SIZE.x, 0)).rgb;
	float3 top = TEXTURE_GLOSSINESS.Sample(TEXTURE_GLOSSINESS_Sampler, i.rtuv.zw + float2(0, -PIXEL_SIZE.y)).rgb;
	float3 bot = TEXTURE_GLOSSINESS.Sample(TEXTURE_GLOSSINESS_Sampler, i.rtuv.zw + float2(0, PIXEL_SIZE.y)).rgb;
	float3 srcColor = max(Middle, max(max(left, right), max(top, bot)));
#elif  COLOR_CUSTOM
    float3 srcColor = lerp(COLOR_RANGEA, COLOR_RANGEB, i.random.x);
#endif

#if BLEND_NORMAL
	float3 color = srcColor;
	float final_alpha = alpha;
#elif BLEND_MULTIPLY
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	float3 color = whiteColor - alpha * (whiteColor - srcColor);
	float final_alpha = 1.0;
#elif BLEND_SCREEN
	float3 color = alpha * srcColor;
	float final_alpha = 1.0;
#elif BLEND_HUE
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_SATURATION
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LUMINOSITY
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_COLOR
	float3 baseHSL = RGBToHSL(dstColor);
	float3 blendHSL = RGBToHSL(srcColor);
	float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
	float3 color = lerp(dstColor, resHSLColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_BLEND
	float imgIntensity = dot(float3(0.2990,0.5870,0.1140), dstColor);
	float3 resIntColor = (imgIntensity * 1.68) * srcColor;
	float3 color = lerp(dstColor, resIntColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_EXCLUSION
	float3 resColor = BlendExclusion(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_HARDLIGHT
	float3 resColor = BlendHardLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_VIVIDLIGHT
	float3 resColor = BlendVividLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_OVERLAY
	float3 resColor = BlendOverlay(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_COLORBURN
	float3 resColor = BlendColorBurn(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_COLORDODGE
	float3 resColor = BlendColorDodge(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_SOFTLIGHT
	float3 resColor = BlendSoftLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_HARDMIX
	float3 resColor = BlendHardMix(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_PINLIGHT
	float3 resColor = BlendPinLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LINEARLIGHT
	float3 resColor = BlendLinearLight(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_DIFF
	float3 resColor = BlendDiff(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LINEARBURN
	float3 resColor = BlendLinearBurn(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_SUB
	float3 resColor = BlendSub(dstColor, srcColor);
	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_LUT
	float3 resColor;
	resColor.r = _LutMap.Sample(_LutSampler, float2(srcColor.r, dstColor.r)).r;
	resColor.g = _LutMap.Sample(_LutSampler, float2(srcColor.g, dstColor.g)).g;
	resColor.b = _LutMap.Sample(_LutSampler, float2(srcColor.b, dstColor.b)).b;

	float3 color = lerp(dstColor, resColor, alpha);
	float final_alpha = 1.0;
#elif BLEND_ADD
    float3 color = srcColor * alpha;
	float final_alpha = 1.0;
#endif

	mainColor = float4(color, alpha);
 }
 
}
ENDCG
#END
