#SHADER_DEFINE Rgb2GrayVertex

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE Rgb2GrayFragment  

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { COUNT, 		HIGH,	FLOAT,		"count"},
	}

#SHADER_CODE

     vec3 W = vec3(0.2125,0.7154,0.0721);
     vec3 curr = texture2D(uniCurrentTexture,in_TexCooridate).xyz;
     float luminace = dot(curr,W);
     gl_FragColor = step(0.98,cos(count))*vec4(vec3(curr),1.0)+(1.0-step(0.98,cos(count)))*vec4(vec3(luminace),1.0);
     //gl_FragColor = vec4(vec3(luminace),1.0);

#END_CODE
#END_DEFINE