#SHADER_DEFINE FaintedVertex

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE FaintedFragment  

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { COUNT, 		HIGH,	FLOAT,		"count"},
    { MAX_BIAS, 		HIGH,	FLOAT,		"max_bias"},
    { SPEED, 		HIGH,	FLOAT,		"speed"},
	}

#SHADER_CODE

    
    float x = in_TexCooridate.x;
    float bias = max_bias*abs(sin(speed*count));
    vec2 coord1 = in_TexCooridate.xy + vec2(bias,0.0);
    vec2 coord2 = in_TexCooridate.xy + vec2(-bias,0.0);
    vec3 rgb = 0.5*texture2D(uniCurrentTexture,in_TexCooridate).rgb; 
    //vec3 rgb2 = coord1.x > 1.0 ? 0.25*texture2D(uniCurrentTexture,in_TexCooridate).rgb : 0.25*texture2D(uniCurrentTexture,coord1).rgb; 
    //vec3 rgb3 = coord2.x < 0.0 ? 0.25*texture2D(uniCurrentTexture,in_TexCooridate).rgb : 0.25*texture2D(uniCurrentTexture,coord2).rgb; 
    vec3 rgb2 = step(1.0,coord1.x)*0.25*texture2D(uniCurrentTexture,in_TexCooridate).rgb+(1.0-step(1.0,coord1.x))*0.25*texture2D(uniCurrentTexture,coord1).rgb;
    vec3 rgb3 = step(0.0,coord2.x)* 0.25*texture2D(uniCurrentTexture,coord2).rgb+ (1.0-step(0.0,coord2.x))*0.25*texture2D(uniCurrentTexture,in_TexCooridate).rgb; 
    gl_FragColor = vec4(vec3(rgb+rgb2+rgb3),1.0);


#END_CODE
#END_DEFINE
   

