#DEFPARAMS
#END

#DEFTAG
ShaderName = "contourextract"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE_IN;
Texture2D TEXTURE_DIFFUSE_OUT;
SamplerState TEXTURE_DIFFUSE_IN_Sampler;
SamplerState TEXTURE_DIFFUSE_OUT_Sampler;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float value1 = TEXTURE_DIFFUSE_IN.Sample(TEXTURE_DIFFUSE_IN_Sampler, i.uv).a;
	float value2 = TEXTURE_DIFFUSE_OUT.Sample(TEXTURE_DIFFUSE_OUT_Sampler, i.uv).a;
	float resValue = 0;
	if(value1 < 0.2) 	
    {
		resValue = value2*(1.0 - value1);
		resValue *= 20.0;
		resValue = min(1.0 , resValue);
		//resValue *= (1.0 - value1);
	}
	else if(value2 > value1 )
    {
		resValue = value2 - value1;
		resValue = resValue * 20 * (1.0 - value1);
		resValue = min(1.0 , resValue);
		//resValue *= (1.0 - value1);
	}
	//resValue = clamp(resValue * 20, 0.0, 1.0);
	mainColor = float4(resValue, resValue, resValue, resValue);
}
ENDCG
#END
