
#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_COLOR = {"TEXTURE_COLOR", TEXTURE2D, "white" },
TEXTURE_MASK = {"TEXTURE_MASK", TEXTURE2D, "white"},
BGSIZE = { "BGSIZE", VEC2, "0.0,0.0"},
BLEND_MODE = {"BLEND_MODE", FLOAT, "0.0"},
MATERIAL_MODE = {"MATERIAL_MODE", FLOAT, "0.0"},
BlendOpacity = {"Blend_Opacity", FLOAT, "1.0"},
LightRange = {"LightRange", FLOAT, "1.0"},
GlowIntense = {"GlowIntense", FLOAT, "1.0"},
LineContrast = {"LineContrast", FLOAT, "1.0"},
GlowContrast = {"GlowContrast", FLOAT, "1.0"},
TEXTURESIZE = { "TEXTURESIZE", VEC2, "0.0,0.0"},
BlendColor = { "BlendColor", VEC4, "0.0,0.0,0.0,0.0"},
LightColor = { "LightColor", VEC4, "0.0,0.0,0.0,0.0"},
#END

#DEFTAG
ShaderName = "contour_sticker"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

float2 BGSIZE;
float2 TEXTURESIZE;

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	float4 in_Position = v.in_Position;
	half2 in_Coordinate = v.in_Coordinate;

	o.out_Coordinate = in_Coordinate;
	o.vertex = UniformNDC(in_Position);
	return o;
}



float BlendOverlayf(float base, float blend)
{
    return (base < 0.5 ? (2.0 * (base) * (blend)) : (1.0 - 2.0 * (1.0 - (base)) * (1.0 - (blend))));
}

float3 BlendOverlay(float3 base, float3 blend)
{
	return float3(BlendOverlayf(base.r, blend.r), BlendOverlayf(base.g, blend.g), BlendOverlayf(base.b, blend.b));
}

float BlendLightenf(float base, float blend)
{
    return max(blend, base);
}

float BlendDarkenf(float base, float blend)
{
    return min(blend, base);
}


float BlendPinLightf(float base, float blend) 
{
    if(blend < 0.5)
	{
        return BlendDarkenf(base, 2.0 * blend);
    }
    else
	{
        return BlendLightenf(base, 2.0 * (blend - 0.5));
    }
}

float3 BlendPinLight(float3 base, float3 blend)
{
	return float3(BlendPinLightf(base.r, blend.r), BlendPinLightf(base.g, blend.g), BlendPinLightf(base.b, blend.b));
}


float blendOverlay(float base, float blend) {
	return base<0.5?(2.0*base*blend):(1.0-2.0*(1.0-base)*(1.0-blend));
}

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_COLOR;
Texture2D TEXTURE_MASK;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_COLOR_Sampler;
SamplerState TEXTURE_MASK_Sampler;
float BLEND_MODE;
float BlendOpacity;
float LightRange;
float MATERIAL_MODE;
float4 LightColor;
float4 BlendColor;
float GlowIntense;
float LineContrast;
float GlowContrast;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#define in_blend_mode BLEND_MODE
	//#define in_blend_opacity BlendOpacity

	float range = LightRange;

	float4 TextureColor = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, i.out_Coordinate.xy);
	int color_mode = int(MATERIAL_MODE + 0.5);
	if (color_mode == 2)
	{
		TextureColor = float4(BlendColor.r,BlendColor.g,BlendColor.b,1.0);//BlendColor;// float4(0.5,0.0,0.0,1.0);//PURECOLOR;
	}
	//float4 TextureColor = float4(1.0, 0.0, 0.0, 1.0); //Sample( TEXTURE_DIFFUSE, i.out_Coordinate.xy);
	float4 TextureImageColor = TEXTURE_COLOR.Sample( TEXTURE_COLOR_Sampler, i.out_Coordinate.xy);
	float4 TextureMask = TEXTURE_MASK.Sample( TEXTURE_MASK_Sampler, i.out_Coordinate.xy);
    TextureMask.a = smoothstep(0.0, LineContrast, TextureMask.a);

	float4 resultColor;
	float3 blendColor = TextureColor.rgb;
	float3 lightColor = float3(LightColor.r, LightColor.g, LightColor.b);
	float4 srcColor = TextureImageColor;
	int blend_mode = int(in_blend_mode + 0.5);
	float in_blend_opacity = BlendOpacity * TextureMask.a;
	if( blend_mode == 1 ){
		float3 blendRGB = srcColor.rgb * (1.0 - TextureColor.a) + blendColor.rgb * TextureColor.a;
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, 1);
 	 }else if( blend_mode == 2 ){
		float3 blendRGB = clamp(srcColor.rgb + blendColor.rgb, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, TextureColor.a);
		lightColor = clamp(srcColor.rgb + lightColor.rgb, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
	}else if( blend_mode == 3 ){
		float3 blendRGB = float3(max(srcColor.r,blendColor.r),max(srcColor.g,blendColor.g),max(srcColor.b,blendColor.b));
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, TextureColor.a);
		lightColor = float3(max(srcColor.r,lightColor.r),max(srcColor.g,lightColor.g),max(srcColor.b,lightColor.b));
	}else if( blend_mode == 4 ){
		float3 blendRGB = srcColor.rgb * blendColor.rgb;
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, TextureColor.a);
		lightColor =  srcColor.rgb * lightColor.rgb;
	}else if( blend_mode == 5 ){
		float3 blendRGB = float3(blendOverlay(srcColor.r,blendColor.r),blendOverlay(srcColor.g,blendColor.g),blendOverlay(srcColor.b,blendColor.b));
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, TextureColor.a);
		lightColor = float3(blendOverlay(srcColor.r,lightColor.r),blendOverlay(srcColor.g,lightColor.g),blendOverlay(srcColor.b,lightColor.b));
	}else if( blend_mode == 6 ){
		float3 blendRGB = 1.0-((1.0-srcColor.rgb)*(1.0-blendColor.rgb));
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, TextureColor.a);
		lightColor =  1.0-((1.0-srcColor.rgb)*(1.0-lightColor.rgb));
	}else if( blend_mode == 7) {
		float3 blendRGB = clamp(srcColor.rgb + 2*blendColor.rgb - 1, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, TextureColor.a);
		lightColor =  clamp(srcColor.rgb + 2*lightColor.rgb - 1, float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
	}else if( blend_mode == 8) {
		float3 blendRGB = BlendPinLight(srcColor.rgb, blendColor.rgb);
		//blendRGB = blendRGB * in_blend_opacity + srcColor.rgb * (1.0 - in_blend_opacity);
    	resultColor =  float4(blendRGB.r, blendRGB.g, blendRGB.b, TextureColor.a);
		lightColor =  BlendPinLight(srcColor.rgb, lightColor.rgb);;
	}

	if (range == 0)
	{
		mainColor = float4(resultColor.r, resultColor.g, resultColor.b, TextureColor.a*in_blend_opacity);
	}

	// float mask_threshold = 0;
	// if (TextureMask.a > 0)
	// {
	// 	mask_threshold = 1;
	// }
	// float opcaity = max(TextureMask.a, TextureMask.r*TextureMask.r*GlowIntense);
	// float opcaity =TextureMask.r*GlowIntense;
    float opcaity = smoothstep(0.0, GlowContrast, TextureMask.r);

	resultColor = resultColor*TextureMask.a + (1 -TextureMask.a)*float4(lightColor.r, lightColor.g, lightColor.b, 0);

	//float opcaity = max(TextureMask.a, TextureMask.r*TextureMask.r*GlowIntense);//clamp(TextureMask.a + TextureMask.r, 0, 1);
	// return float4(resultColor.r, resultColor.g, resultColor.b, TextureColor.a*opcaity*BlendOpacity);
	opcaity = max(TextureMask.a,opcaity*BlendOpacity);
	mainColor = float4(resultColor.r, resultColor.g, resultColor.b, opcaity);

	//return float4(inner, inner, inner, 1.0);
}

ENDCG
#END
