--local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"


local android_ios_video_cutter = {}

function android_ios_video_cutter:Initialize(camera, imagedoc, imagefile, pointfile)
  -- 创建一个伪摄像头数据,用于反序列化加载素材,在真正渲染之前会更新
  self.mCamTexStream = apolloengine.TextureStream();
  self.mCamTexStream:SetStreamType(mathfunction.vector2(16, 16), apolloengine.TextureEntity.PF_R8G8B8);
  self.mCamTexEntity = apolloengine.TextureEntity();
  self.mCamTexEntity:PushMetadata(
          apolloengine.TextureBufferMetadata(
                  apolloengine.TextureEntity.TU_WRITE,
                  1, false,
                  apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                  apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                  apolloengine.TextureEntity.TF_LINEAR,
                  apolloengine.TextureEntity.TF_LINEAR,
                  self.mCamTexStream ));
  self.mCamTexEntity:SetKeepSource(true);
  self.mCamTexEntity:CreateResource();
  apolloengine.DeviceResource:PushDeviceResource(
          apolloengine.DeviceResource.DEVICE_CAPTURE,
          self.mCamTexEntity);

    --新帧回调
  self.node = apollonode.QuadNode()
  self.node:CreateResource("comm:documents/material/imageblit.material");
  --renderqueue:Prev(self.node)
  self.node:SetSequence(camera:GetSequence());
end

function android_ios_video_cutter:Update(def)
  return true;
end

--得到当前的视屏纹理
function android_ios_video_cutter:GetVideoTexture()
  return self.mCamTexEntity;
end

function android_ios_video_cutter:SetTexture(size, texid)  
  LOG("video size w: "..size[1].." h: "..size[2]);
  self.size = size;
  if size and texid then
    local tex = apolloengine.TextureEntity();
    tex:PushMetadata(
      apolloengine.TextureResourceMetadata(
        mathfunction.vector2(size[1], size[2]),
        texid,
        apolloengine.TextureEntity.PF_YUV420P,
        true -- C++ ITextureResource::RefrenceTexture
      ));
    tex:CreateResource();
    self.mCamTexEntity = tex;
    self.mCamTexStream = tex:GetSourceStream();
    self.node:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      self.mCamTexEntity);
  else
    ERROR("empty size or texid");
  end
  apolloengine.DeviceResource:PushDeviceResource(
      defiend.LAST_QUEUE_TEXTURE,
      self.mCamTexEntity);
  apolloengine.DeviceResource:PushDeviceResource(
        apolloengine.DeviceResource.DEVICE_CAPTURE,
        self.mCamTexEntity);    
end

return android_ios_video_cutter;